<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* DefenderDetectedMalwareActions File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Beta\Microsoft\Graph\Model;
/**
* DefenderDetectedMalwareActions class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class DefenderDetectedMalwareActions extends Entity
{

    /**
    * Gets the highSeverity
    * Indicates a Defender action to take for high severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @return DefenderThreatAction The highSeverity
    */
    public function getHighSeverity()
    {
        if (array_key_exists("highSeverity", $this->_propDict)) {
            if (is_a($this->_propDict["highSeverity"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\DefenderThreatAction")) {
                return $this->_propDict["highSeverity"];
            } else {
                $this->_propDict["highSeverity"] = new DefenderThreatAction($this->_propDict["highSeverity"]);
                return $this->_propDict["highSeverity"];
            }
        }
        return null;
    }

    /**
    * Sets the highSeverity
    * Indicates a Defender action to take for high severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @param DefenderThreatAction $val The value to assign to the highSeverity
    *
    * @return DefenderDetectedMalwareActions The DefenderDetectedMalwareActions
    */
    public function setHighSeverity($val)
    {
        $this->_propDict["highSeverity"] = $val;
         return $this;
    }

    /**
    * Gets the lowSeverity
    * Indicates a Defender action to take for low severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @return DefenderThreatAction The lowSeverity
    */
    public function getLowSeverity()
    {
        if (array_key_exists("lowSeverity", $this->_propDict)) {
            if (is_a($this->_propDict["lowSeverity"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\DefenderThreatAction")) {
                return $this->_propDict["lowSeverity"];
            } else {
                $this->_propDict["lowSeverity"] = new DefenderThreatAction($this->_propDict["lowSeverity"]);
                return $this->_propDict["lowSeverity"];
            }
        }
        return null;
    }

    /**
    * Sets the lowSeverity
    * Indicates a Defender action to take for low severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @param DefenderThreatAction $val The value to assign to the lowSeverity
    *
    * @return DefenderDetectedMalwareActions The DefenderDetectedMalwareActions
    */
    public function setLowSeverity($val)
    {
        $this->_propDict["lowSeverity"] = $val;
         return $this;
    }

    /**
    * Gets the moderateSeverity
    * Indicates a Defender action to take for moderate severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @return DefenderThreatAction The moderateSeverity
    */
    public function getModerateSeverity()
    {
        if (array_key_exists("moderateSeverity", $this->_propDict)) {
            if (is_a($this->_propDict["moderateSeverity"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\DefenderThreatAction")) {
                return $this->_propDict["moderateSeverity"];
            } else {
                $this->_propDict["moderateSeverity"] = new DefenderThreatAction($this->_propDict["moderateSeverity"]);
                return $this->_propDict["moderateSeverity"];
            }
        }
        return null;
    }

    /**
    * Sets the moderateSeverity
    * Indicates a Defender action to take for moderate severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @param DefenderThreatAction $val The value to assign to the moderateSeverity
    *
    * @return DefenderDetectedMalwareActions The DefenderDetectedMalwareActions
    */
    public function setModerateSeverity($val)
    {
        $this->_propDict["moderateSeverity"] = $val;
         return $this;
    }

    /**
    * Gets the severeSeverity
    * Indicates a Defender action to take for severe severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @return DefenderThreatAction The severeSeverity
    */
    public function getSevereSeverity()
    {
        if (array_key_exists("severeSeverity", $this->_propDict)) {
            if (is_a($this->_propDict["severeSeverity"], "Solid_Backups\Strauss\Beta\Microsoft\Graph\Model\DefenderThreatAction")) {
                return $this->_propDict["severeSeverity"];
            } else {
                $this->_propDict["severeSeverity"] = new DefenderThreatAction($this->_propDict["severeSeverity"]);
                return $this->_propDict["severeSeverity"];
            }
        }
        return null;
    }

    /**
    * Sets the severeSeverity
    * Indicates a Defender action to take for severe severity Malware threat detected. Possible values are: deviceDefault, clean, quarantine, remove, allow, userDefined, block.
    *
    * @param DefenderThreatAction $val The value to assign to the severeSeverity
    *
    * @return DefenderDetectedMalwareActions The DefenderDetectedMalwareActions
    */
    public function setSevereSeverity($val)
    {
        $this->_propDict["severeSeverity"] = $val;
         return $this;
    }
}
