<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* ScheduleEntityTheme File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Microsoft\Graph\Model;

use Solid_Backups\Strauss\Microsoft\Graph\Core\Enum;

/**
* ScheduleEntityTheme class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class ScheduleEntityTheme extends Enum
{
    /**
    * The Enum ScheduleEntityTheme
    */
    const WHITE = "white";
    const BLUE = "blue";
    const GREEN = "green";
    const PURPLE = "purple";
    const PINK = "pink";
    const YELLOW = "yellow";
    const GRAY = "gray";
    const DARK_BLUE = "darkBlue";
    const DARK_GREEN = "darkGreen";
    const DARK_PURPLE = "darkPurple";
    const DARK_PINK = "darkPink";
    const DARK_YELLOW = "darkYellow";
    const UNKNOWN_FUTURE_VALUE = "unknownFutureValue";
}