<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/
?>
<?php get_header(); ?>

<!--
index.php
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<!--
Content of the page (inc comments and post details)
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

<div id="page-body-wrapper">

<?php
$is_full_page = hmt4_get_option('hmt_featured_full');
$hide_recent_posts = hmt4_get_option('hmt_hide_recent_posts');
$hide_home_sidebar = hmt4_get_option('hmt_hide_home_sidebar');

if (!$is_full_page) {
?>
	<div id="content">
<?php
}
?>
<?php hmt_show_slider(); ?>

<!--
The Home Page 'Page Block'
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->
		<?php	

		$thispage = new WP_Query(  );
		$option = hmt4_get_option('hmt_featured'); 	// get the featured page option
		
		if (!is_numeric($option)){
			$thispage->query('pagename=' . $option);
			$this_post_id = hmt_get_id_by_slug($option);
		}
		else {
			$thispage->query('page_id=' . $option);
			$this_post_id = $option;
		}
			
		if (($option!="") && (!is_paged())) { 		// if a featured home page option has been specified  
								// and this is is the first page of posts, then show the featured page
			$thispage->the_post(); ?>
			
<!--
The Home Page 'Page Block' content 
~~~ -->
			<div id="post-<?php the_ID(); ?>" <?php post_class('',$this_post_id); ?>> 
            
				<div class="featured-page-content <?php  if ($is_full_page) print 'featured-page-full-width';?>">
			
<!--
Widget Area: [All Content] Above 
~~~ -->			
					<?php 		
                    if (hmt_is_sidebar_active('sidebar-7')):
                    ?>
                        
                        <div id="all-content-above">
                        
                            <span class="all-content-above-widget-block">
                                <?php dynamic_sidebar('sidebar-7'); ?>
                            </span>
                        
                        </div> <!-- id="all-content-above" -->
                        <div class="clearFloat"></div>
                    
                    <?php
                    endif;
            
                    $ads_already_shown = TRUE;										// this lets subsequent blog posts know that they are not the first thing on the page
                                                                                    // and therefore no ads will be shown around them. Ads only show on the first item on the page.
                    global $h1_setting;
                    
                    if (!hmt4_get_option('hmt_hide_featured_page_title')) {
                        if (($h1_setting == "FEATURED PAGE") || ($h1_setting == "")) {
                            echo '<h1 class="h1-underline">'; the_title(); echo '</h1>';	// This is the most important thing on the page for indexing and therefore gets a H1
                        }																	// unless there is something lurking in the SEO bar - in which case the theme gives this H2
                        else {																// and assumes that you are going to be smart enough to put something with a h1 up there!
                            echo '<h2 class="h2-simulate-h1-size-underline">'; the_title(); echo '</h2>';
                        }
                    }
                    ?>
                    
                    <?php
                    if (hmt_is_sidebar_active('sidebar-9')):
                    ?>
                        
                        <div id="content-item-above">
                        
                        <span class="content-item-above-widget-block">
                            <?php dynamic_sidebar('sidebar-9'); ?>
                        </span>
                        
                        </div> <!-- id="content-item-above" -->
                    
                    <?php
                    endif;
                    ?>
                    
                    
                    <?php 
                    if (hmt_is_sidebar_active('sidebar-11')):
                    ?>
                        <div id="content-item-left">
                            
                            <ul>
                            <?php dynamic_sidebar('sidebar-11'); ?>
                            </ul>
                        
                        </div> <!-- id="content-item-left" -->
                    <?php
                    endif;
                    ?>
                    
                    
                    <?php 
                    if (hmt_is_sidebar_active('sidebar-12')):
                    ?>
                        <div id="content-item-right">
                            
                            <ul>
                            <?php dynamic_sidebar('sidebar-12'); ?>
                            </ul>
                        
                        </div> <!-- id="content-item-right" -->
                    <?php
                    endif;
                    ?>				
                    
                    <?php
                    
                    if (function_exists('has_post_thumbnail') && has_post_thumbnail()) {  //  okay so if this post has a thumbnail (as per wp 2.9 thumnail features) then do something about it
                    
                        if (hmt4_get_option('hmt_common_thumbnail_left_or_right')=='RIGHT') print '<div class="common-page-thumbnail-right">';
                        else print '<div class="common-page-thumbnail-left">';	

                        if( get_post_meta($post->ID, "aff-link", true)){  
                        	echo ' <a href="'.get_post_meta($post->ID, "aff-link", true).'" ';                         
                        	if( get_post_meta($post->ID, "aff-link-nofollow", true)){  echo ' rel="nofollow" '; } 
                       		echo '  title="' . the_title_attribute('echo=0') . '" >';
                        }
	   
                        the_post_thumbnail('post-image-size');
						if( get_post_meta($post->ID, "aff-link", true)){
                        	echo "</a>";
                        }

                        ?>
                        </div>
                    
                    <?php 	
                    }
                    the_content();
                    
                    if (hmt_is_sidebar_active('sidebar-10')):
                    ?>
                        <div id="content-item-below">
                            <span class="content-item-below-widget-block">
                                <?php dynamic_sidebar('sidebar-10'); ?>
                            </span>
                        </div> <!-- id="content-item-below" -->
                            
                        <div class="clearFloat"></div>
                    <?php 
                    endif;
                    
                    echo "\n"; 
                    ?>
        
                    <?php edit_post_link(__('(Edit)','hmth'), '<p>', '</p>'); ?>
        
                </div> <!-- class="featured-page-content" -->
                
                <?php
                if 	((!$hide_recent_posts==true) &&
                    (hmt4_get_option('hmt_hide_details_for_home') && is_home()  && (!$is_full_page)))
                {
                ?>
                    <div class="post-divider">   <?php /* divide posts if post details are not showing */ ?>
                        <hr/>
                    </div> <!-- class="post-divider" -->
                <?php
                }
                ?>
                
    
                <div class="clearFloat"></div>
	
<!--
The Home Page 'Page Block' post details 
~~~ -->

				<?php	/* remove post details as set in the heatmap options */
                if (!hmt4_get_option('hmt_hide_details_for_home') && is_home()  && (!$is_full_page) && (!hmt4_get_option('hmt_hide_featured_page_detail')))	
                {
                    ?>
            
                    <div class="featured-page-details">	
                    
                    <?php get_template_part('like-buttons'); ?>	
            
                        <p><?php _e('Posted by','hmth'); ?>
                        
                            <?php echo get_the_author(); ?>
                            <?php /* the_author_posts_link(); */ /*uncomment this if you actually want a link to the authors posts - it reveals the authors username though - or am I being too security concious? */ ?>
                             - 
                            <?php echo get_the_date();?> <?php _e('at','hmth'); ?>  <?php the_time(); /* changed date and time format so that default system date and time is used instead of preset date and time */ ?>
                        </p>
                    
                    </div> <!-- class="featured-page-details" -->
                    
                <?php
                } 
                ?>
        
            </div> <!-- post_class -->
            
        <?php   
		}
		?>
	
<?php
if ($hide_home_sidebar) {
?>
	<div id="content-full-width">
<?php
}
else
if ($is_full_page) {
?>
	<div id="content">
<?php
}
?>    

		<?php 
		if (!$hide_recent_posts==true) {
			
			$include_cat=hmt4_get_option('hmt_include_cat_home_post');
			$ishome=is_home();
			$iscat=is_category();
			$isarch=is_archive();
			if(isset($include_cat) && trim($include_cat)!="" )
			{
				global $query_string, $wp_query;				
				query_posts($query_string.'&cat='.$include_cat);
				$wp_query->is_home=$ishome;
				$wp_query->is_archive=$isarch;
				$wp_query->is_category=$iscat;
			}
			 
			 
			 get_template_part("common"); 
		}
		?>
         
<!--
Widget Area: [All Content] Below
~~~ -->
	<?php
    if (hmt_is_sidebar_active('sidebar-8')):
    ?>
        
        <div id="all-content-below">
        
        	<span class="all-content-below-widget-block">
            	<?php dynamic_sidebar('sidebar-8'); ?>
            </span>
        
        </div> <!-- id="all-content-below" -->
    
    <?php
    endif;
	?>
	
<!--
Previous and Next Page navigation
~~~ -->

	<?php
	if (!$hide_recent_posts==true) {
	?>
    	<div class="post-nav"><p><?php posts_nav_link(); ?></p></div>    
	<?php
	}
	wp_reset_query();  
	?>
		
	</div> <!-- id="content" -->
	
	<?php
	
	if (!hmt4_get_option('hmt_no_sidebars_mode')) {  
		if (!$hide_home_sidebar==true) {
			get_sidebar(); 
		}
	}
	?>
    
<!--
[Footer Above]
~~~~~~~~~~~~~~~~~~~~~~~~ ~~~ -->

	<?php 
    if (hmt_is_sidebar_active('footer_above')):
    ?>

        <div id="footer-above">
        
            <ul class="footer-above-widget-block">
            	<?php dynamic_sidebar('footer_above'); ?> 
            </ul>
            
        </div> <!-- id="footer-above" -->

        <div class="clearFloat"></div>
    
    <?php 
    endif;
    ?>

</div> <!-- id="page-body-wrapper" -->

<?php get_footer(); ?>


<!--
End of index.php
~~~ -->