<?php 
/* 
This file is part of HeatMap Theme Pro v5
Copyright: Stuart Wider
Website: HeatMapTheme.com
*/

add_shortcode( 'hmtad', 'hmtad_func' );
function hmtad_func( $atts ) {
	extract( shortcode_atts( array(
		'name' => '',
		'align' => 'floatleft',
	), $atts ) );
	if($name=='')
		return '';
	else
		return generate_adbox(array('name'=>$name,'align'=>$align));
}
add_filter('the_excerpt', 'remove_hmtad_shortcode');
//add_filter('the_content', 'remove_hmtad_shortcode_fromContent');
function remove_hmtad_shortcode($content)
{
	$regex = '/\[hmtad\s*.*?\]/i';
	preg_match_all( $regex, $content, $matches );
	foreach($matches[0] as $match)
	{ 
		$content = str_replace($match, '', $content);
	}
	return $content;
}
function remove_hmtad_shortcode_fromContent($content)
{
//if(!is_single())
//{
	$content=remove_hmtad_shortcode($content);
//}
	return $content;
}


function generate_adbox($param)
{ 
	global  $options;
	$ret='';
	foreach ($options as $value)
	{ 		// Loop through the options array looking for ad widgets.
		if( $value['type']="ad-combo" && isset($value['id']) )
		{				
			$this_option = hmt4_get_option($value['id']);
			if ($this_option != "") 
			{
				$this_name = hmt4_get_option($value['id'] . '_name');
				$param['name']=str_replace("&#8211;","-",trim($param['name']));
				if(trim($this_name) == $param['name'])
				{
				
					if ((is_page() and hmt4_get_option($value['id'] . '_Page')) ||
					(is_single() and hmt4_get_option($value['id'] . '_Post')) ||   
					(is_category() and hmt4_get_option($value['id'] . '_Category')) ||
					(is_search() and hmt4_get_option($value['id'] . '_Search')) ||
					(is_archive() and hmt4_get_option($value['id'] . '_Archive')) ||	
					(is_home() and hmt4_get_option($value['id'] . '_Home')) ||
					is_404())
					{ 
						$ret='<span class="hmtad ';
						$ret.=str_ireplace(" ","-",$this_name).' ';
						if(isset($param['align']))
						{
							$ret.="hmtad-".$param['align'];
						}
						else
						{
							$ret.="hmtad-floatleft";
						}
						$ret.='">' . hmt_display_rotated_ad($this_option) .'</span>';
					}
				}				
			}
		}
	} 
	return $ret;
}


function hmt_shortcode_box_fun()
{
	global  $options;
	
	// Dont include the jquery popup box for anything other than pages and posts
	global $post;
	if (!(('post' == $post->post_type) || ('page' == $post->post_type)))
		return;
?>
<table width="100%" cellspacing="0" border="0">
	<tbody>
		<tr>
			<th width="20%" valign="top" align="left" style="padding-top: 6px;">
				<?php _e("Ad Name",'hmth'); ?>
			</th>
			<td style="padding-left:5px; padding-top: 6px;">
				<select id="hmt-shortcode-adname" style=" font-size:11px;">
				<?php
					foreach ($options as $value)
					{ 		// Loop through the options array looking for ad widgets.
						if( $value['type']="ad-combo" )
						{				
							$this_option = hmt4_get_option($value['id']);
							if ($this_option != "") 
							{
								$this_name = hmt4_get_option($value['id'] . '_name');
								if($this_name!="")
								{
									echo '<option value="'.$this_name.'">'.$this_name.'</option>';				
								}
							}
						}
					} 
				?>
				</select>
			</td>
		</tr>
		<tr>
			<th valign="top" align="left" style="padding-top: 6px;">
				<?php _e("Alignment",'hmth'); ?>
			</th>
			<td style="padding-left:5px; padding-top: 6px;">
				<select id="hmt-shortcode-align" style="font-size:11px;" >
					<option value="floatleft"><?php _e("Float Left",'hmth'); ?></option>
					<option value="floatright"><?php _e("Float Right",'hmth'); ?></option>
					<option value="left"><?php _e("Left",'hmth'); ?></option>
					<option value="center"><?php _e("Center",'hmth'); ?></option>
					<option value="right"><?php _e("Right",'hmth'); ?></option>
				</select><br/><br/>
			</td>
		</tr>
		<tr>
			<td>			
			</td>
			<td>
				<input type="button" value="<?php _e("Insert HMT ad",'hmth'); ?>" class="button" onclick="insert_ad_shortcode()" />
			</td>
		</tr>
	</tbody>
</table>
<?php
}

add_action( 'edit_form_advanced',  'hmt_ad_shortcode_data') ;
add_action( 'edit_page_form',  'hmt_ad_shortcode_data' );
function hmt_ad_shortcode_data()
{
	// Dont include the jquery popup box for anything other than pages and posts
	global $post;
	if (!(('post' == $post->post_type) || ('page' == $post->post_type)))
		return;
?>
<script type="text/javascript">
function open_ad_shortcode_box()
{
	jQuery( "#ad_shortcode" ).dialog('open');
}

	jQuery(document).ready(function(){
		// Add the buttons to the HTML view
		jQuery("#ed_toolbar").append('<input type="button" onclick="open_ad_shortcode_box()" value="HMT ad" />');		
		
		jQuery( "#dialog:ui-dialog" ).dialog( "destroy" );
	
		jQuery( "#ad_shortcode" ).dialog({
			height: 200,
			width: 320,
			modal: true,
			autoOpen: false,
			dialogClass: 'wp-dialog'
			});
		});
		
		
function insert_ad_shortcode()
{
		text='[hmtad name="'+jQuery('#hmt-shortcode-adname').val()+'" align="'+jQuery('#hmt-shortcode-align').val()+'"]';
		if ( typeof tinyMCE != 'undefined' && ( ed = tinyMCE.activeEditor ) && !ed.isHidden() ) {
			ed.focus();
			if (tinymce.isIE)
				ed.selection.moveToBookmark(tinymce.EditorManager.activeEditor.windowManager.bookmark);

			ed.execCommand('mceInsertContent', false, text);
		} else
			edInsertContent(edCanvas, text);
		jQuery( "#ad_shortcode" ).dialog('close');
}
</script>

<div id="ad_shortcode" style="padding:15px;" title="<?php  _e("HeatMap Theme Pro - Ad ShortCode",'hmth'); ?>">
<?php hmt_shortcode_box_fun(); ?>
</div>
<?php
}

function myplugin_addbuttons() {
   // Don't bother doing this stuff if the current user lacks permissions
   	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
     	return;
 
   // Add only in Rich Editor mode
   	if ( get_user_option('rich_editing') == 'true') {
     add_filter("mce_external_plugins", "add_myplugin_tinymce_plugin");
     add_filter('mce_buttons', 'register_myplugin_button');
   }
}
 
function register_myplugin_button($buttons) {
   array_push($buttons, "separator", "ad_shortcode");
   return $buttons;
}

// Load the TinyMCE plugin : editor_plugin.js (wp2.5)
function add_myplugin_tinymce_plugin($plugin_array) {
   $plugin_array['ad_shortcode'] = get_template_directory_uri().'/tinymce3/editor_plugin.js';
   return $plugin_array;
}
 
// init process for button control

add_action('init', 'myplugin_addbuttons');
?>