<?php
/**
 * Importer Backup Importer Script
 *
 * ATTENTION: IF YOU ARE READING THIS WHILE TRYING TO LOAD IMPORTBUDDY TO RESTORE YOUR SITE:
 * Your server is not properly handling PHP files. Contact your hosting provider to fix this.
 * Notify them that PHP files are not executing and instead are outputting their code contents.
 *
 * @package BackupBuddy
 */

/**
 * <!-- Importer Restore & Migration Tool - SolidWP.com
 *
 * @version 9.1.14 (downloaded 2024-12-10T12:18:35+00:00)
 * @author SolidWP.com
 * @developer Dustin Bolton
 * @created Feb 11, 2010
 *
 * ###############################################################################################
 * #                                                                                             #
 * #  THERE ARE NO USER-EDITABLE PORTIONS OF THIS FILE! DO NOT EDIT UNLESS DIRECTED BY SUPPORT!  #
 * #                                                                                             #
 * ###############################################################################################
 */

define( 'PB_PASSWORD', 'f00bdfd475bb4661c50caee90be7873d' ); // Update this portion with the hashed password to override a forgotten password.

$php_minimum         = '7.2'; // User's PHP must be equal or newer to this version.
$ignore_not_writable = false; // Set to true to ignore is_writable() returning false on this directory. Useful for servers lying about the writable status of the directory.

// Uncomment the following line when 500 Internal Server Error occurs.
// error_reporting( E_ALL );

if ( version_compare( PHP_VERSION, $php_minimum ) < 0 ) {
	die( 'ERROR #9013. See <a href="https://go.solidwp.com/error-codes">this page for details</a>. Sorry! PHP version ' . $php_minimum . ' or newer is required for Solid Backups to properly run. You are running PHP version ' . PHP_VERSION . '.' );
}

global $importbuddy_file;
$importbuddy_file = basename( __FILE__ ); // filename of importbuddy.php (or whatever it is named).

global $wp_version;
$wp_version = '4.4'; // Spoof a version for new wp-db class.
$abspath    = rtrim( dirname( __FILE__ ), '\\/' ) . '/';

define( 'ABSPATH', $abspath );
define( 'WP_CONTENT_DIR', $abspath . 'wp-content' );
define( 'PB_BB_VERSION', '9.1.14 (downloaded 2024-12-10T12:18:35+00:00)' );
define( 'DB_CHARSET', 'utf8' ); // Default only. Overriden later if needed. Used by wpdb class.
define( 'DB_COLLATE', '' ); // Default only. Overriden alter if needed. Used by wpdb class.

@date_default_timezone_set( @date_default_timezone_get() ); // Prevents date() from throwing a warning if the default timezone has not been set. Run prior to any file_exists()!

/**
 * Checks the current step.
 *
 * @return int|false  Current step or false when step not found or invalid.
 */
function ib_directory_browsing_allowed() {
	if ( ! isset( $_GET['step'] ) ) {
		return false;
	}

	$step = $_GET['step'];

	if ( ! is_numeric( $step ) ) {
		return false;
	}

	if ( $step < 5 ) {
		return false;
	}

	return $step;
}

// Try to put an index.htm file in place during import to help prevent against file browsing. Only do if not a defined step OR a non-numeric defined step OR a defined numeric step < 5.
if ( ! ib_directory_browsing_allowed() ) {
	if ( ! file_exists( ABSPATH . 'index.htm' ) && ! file_exists( ABSPATH . 'index.php' ) ) {
		@file_put_contents( ABSPATH . 'index.htm', '<html></html>' );
	}
}

// If inside BB install then die. Else unpack importbuddy if needed.
if ( @file_exists( @dirname( @dirname( __FILE__ ) ) . '/backupbuddy.php' ) ) {
	die( '<html>Access Denied</html>' );
}


// Unpack importbuddy files into importbuddy directory. Does this when importbuddy directory does not exist OR if now request GET or POST params are sent (aka the first page only).
if ( ! file_exists( ABSPATH . 'importbuddy' ) || ( ( count( $_GET ) == 0 ) && ( count( $_POST ) == 0 ) ) ) {

	$importbuddy_contents = file_get_contents( __FILE__ );
	if ( false === $importbuddy_contents ) {
		die( 'Error #8494834: Unable to read in importbuddy file `' . __FILE__ . '` for validating.' );
	}

	// Make sure this file is complete and contains all the packed data to the end before proceeding.
	if ( false === strpos( $importbuddy_contents, '###PACKDATA' . ',END' ) ) { // Concat here so we don't false positive on this line when searching.
		die( 'ERROR: It appears your `' . __FILE__ . '` file is incomplete.  It may have not finished downloading or uploading completely.  Please try re-downloading the script from within Solid Backups in WordPress (do not just copy the file from the plugin directory) and re-uploading it.' );
	}

	// Make sure no leading whitespace. Some servers introduce this to the beginning, breaking authentication due to output before auth headers being sent.
	if ( ltrim( $importbuddy_contents ) !== $importbuddy_contents ) {
		if ( false === ( file_put_contents( __FILE__, ltrim( $importbuddy_contents ) ) ) ) {
			die( 'Error #84394834: Your importbuddy file `' . __FILE__ . '` file contains leading whitespace/newslines and the script could not re-write it to fix it for you (possibly due to permissions). Please re-download it or manually edit to make sure it begins with <?php with no spaces or newlines/enters before it.' );
		} else { // Re-wrote file.
			sleep( 1 );
			die( '<meta http-equiv="refresh" content="1">Refreshing... Removed unexpected leading whitespace found in importbuddy.php file.' );
		}
	}

	$importbuddy_contents = '';

	$unpack_importbuddy = true;
	if ( file_exists( ABSPATH . 'importbuddy' ) ) { // Importer directory already exists. We may need to re-unpack it if this file has been updated since.
		$signature = @file_get_contents( ABSPATH . 'importbuddy/_signature.php' );
		$signature = trim( str_replace( '<?php die(); ?>', '', $signature ) );
		if ( md5( PB_BB_VERSION . PB_PASSWORD ) != $signature ) { // Signature mismatch. We will need to delete and unpack again to update.
			// echo '<!-- unlinking existing importbuddy directory. -->'; 5.1.0.10: Broke causing headers already sent error due to auth.
			recursive_unlink( ABSPATH . 'importbuddy' );
		} else {
			$unpack_importbuddy = false;
		}
	}
	if ( true === $unpack_importbuddy ) {
		unpack_importbuddy( $ignore_not_writable );
		@file_put_contents( ABSPATH . 'importbuddy/_signature.php', '<?php die(); ?>' . md5( PB_BB_VERSION . PB_PASSWORD ) ); // Create a hash of this Importer version & password. On accessing importbuddy.php's authentication page all importbuddy files will be freshly unpacked if the importbuddy.php version and/or password mismatches to allow users to just replace importbuddy.php to upgrade Importer or password.
	}
}

// Database wrapper.
require_once ABSPATH . 'importbuddy/classes/wp-db.php';
global $wpdb;

if ( isset( $_GET['api'] ) && '' != $_GET['api'] ) { // API ACCESS.
	if ( 'ping' === $_GET['api'] ) {
		die( 'pong' );
	} else {
		die( 'Unknown API access action.' );
	}
} else { // NORMAL ACCESS.
	if ( ! file_exists( ABSPATH . 'importbuddy/init.php' ) ) {
		die( 'Error: Unable to find file `' . ABSPATH . 'importbuddy/init.php`. Make sure that you downloaded this script from within Solid Backups. Copying importbuddy files from inside the plugin directory is not sufficient as many file additions are made on demand.' );
	} else {
		require_once ABSPATH . 'importbuddy/init.php';
	}
}

/**
 * Recursively delete files.
 *
 * @param string $path  Path to start deleting.
 *
 * @return bool  If successful.
 */
function recursive_unlink( $path ) {
	return is_file( $path ) ? @unlink( $path ) : array_map( 'recursive_unlink', glob( $path . '/*' ) ) == @rmdir( $path );
}

/**
 * Unpacks required files encoded in importbuddy.php into stand-alone files.
 *
 * @param bool $ignore_not_writable  Ignore not writeable errors.
 */
function unpack_importbuddy( $ignore_not_writable = false ) {
	if ( ! is_writable( ABSPATH ) && false === $ignore_not_writable ) {
		echo 'Error #224834. This directory, `' . ABSPATH . '`, is not write enabled according to the server. Please verify proper write permissions to continue. If this persists, contact your web hosting provider and tell them that is_writable("' . ABSPATH . '") returns FALSE in PHP.';
		die();
	} else {
		$unpack_file = '';

		$handle = @fopen( __FILE__, 'r' );
		if ( $handle ) {
			while ( ( $buffer = fgets( $handle ) ) !== false ) {
				if ( substr( $buffer, 0, 11 ) == '###PACKDATA' ) {
					$packdata_commands = explode( ',', trim( $buffer ) );
					array_shift( $packdata_commands );

					if ( 'BEGIN' === $packdata_commands[0] ) {
						// Start packed data.
					} elseif ( 'FILE_START' === $packdata_commands[0] ) {
						$unpack_file = $packdata_commands[2];
					} elseif ( 'FILE_END' === $packdata_commands[0] ) {
						$unpack_file = '';
					} elseif ( 'END' === $packdata_commands[0] ) {
						return;
					}
				} else {
					if ( '' != $unpack_file ) {
						if ( ! is_dir( dirname( ABSPATH . $unpack_file ) ) ) {
							$mkdir_result = mkdir( dirname( ABSPATH . $unpack_file ), 0777, true ); // second param makes recursive.
							if ( false === $mkdir_result ) {
								echo 'Error #54455. Unable to mkdir `' . dirname( ABSPATH . $unpack_file ) . '`<br>';
							}
						}
						$fileput_result = file_put_contents( ABSPATH . $unpack_file, base64_decode( $buffer ) );
						if ( false === $fileput_result ) {
							echo 'Error #65656. Unable to put file contents to `' . ABSPATH . $unpack_file . '`.<br>';
						}
					}
				}
			}
			if ( ! feof( $handle ) ) {
				echo 'Error: unexpected fgets() fail.<br>';
			}
			fclose( $handle );
		} else {
			echo 'ERROR #54455: Unable to open `' . __FILE__ . '` file for reading in packaged data.<br>';
		}
	}
}

die();

/*
###PACKDATA,BEGIN
###PACKDATA,FILE_START,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess

###PACKDATA,FILE_END,/_importbuddy/importbuddy/.htaccess,importbuddy/.htaccess
###PACKDATA,FILE_START,/_importbuddy/importbuddy/importbuddy-hooks.php,importbuddy/importbuddy-hooks.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/importbuddy-hooks.php,importbuddy/importbuddy-hooks.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.htm,importbuddy/index.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.html,importbuddy/index.html
PGh0bWw+PC9odG1sPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.html,importbuddy/index.html
###PACKDATA,FILE_START,/_importbuddy/importbuddy/index.php,importbuddy/index.php
PD9waHAKLyoqCiAqIFNpbGVuY2UgaXMgZ29sZGVuLgogKgogKiBAcGFja2FnZSBCYWNrdXBCdWRkeQogKi8K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/index.php,importbuddy/index.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init.php,importbuddy/init.php
PD9waHAKLyoqCiAqIFBsdWdpbiBOYW1lOiBJbXBvcnRCdWRkeQogKiBQbHVnaW4gVVJJOiBodHRwOi8vc29saWR3cC5jb20vCiAqIERlc2NyaXB0aW9uOiBTb2xpZCBCYWNrdXBzIEltcG9ydGVyCiAqCiAqIEBzaW5jZSAxLjAuMgogKiBAYXV0aG9yIER1c3RpbiBCb2x0b24KICogQHBhY2thZ2UgQmFja3VwQnVkZHkKICoKICogSW5zdGFsbGF0aW9uOgogKgogKiAxLiBEb3dubG9hZCBhbmQgdW56aXAgdGhlIGxhdGVzdCByZWxlYXNlIHppcCBmaWxlLgogKiAyLiBJZiB5b3UgdXNlIHRoZSBXb3JkUHJlc3MgcGx1Z2luIHVwbG9hZGVyIHRvIGluc3RhbGwgdGhpcyBwbHVnaW4gc2tpcCB0byBzdGVwIDQuCiAqIDMuIFVwbG9hZCB0aGUgZW50aXJlIHBsdWdpbiBkaXJlY3RvcnkgdG8geW91ciBgL3dwLWNvbnRlbnQvcGx1Z2lucy9gIGRpcmVjdG9yeS4KICogNC4gQWN0aXZhdGUgdGhlIHBsdWdpbiB0aHJvdWdoIHRoZSAnUGx1Z2lucycgbWVudSBpbiBXb3JkUHJlc3MgQWRtaW5pc3RyYXRpb24uCiAqCiAqIFVzYWdlOgogKgogKiAxLiBOYXZpZ2F0ZSB0byB0aGUgbmV3IHBsdWdpbiBtZW51IGluIHRoZSBXb3JkUHJlc3MgQWRtaW5pc3RyYXRpb24gUGFuZWwuCiAqCiAqIE5PVEU6IERPIE5PVCBFRElUIFRISVMgT1IgQU5ZIE9USEVSIFBMVUdJTiBGSUxFUy4gTk8gVVNFUi1DT05GSUdVUkFCTEUgT1BUSU9OUyBXSVRISU4uCiAqLwoKZXJyb3JfcmVwb3J0aW5nKCBFX0VSUk9SIHwgRV9XQVJOSU5HIHwgRV9QQVJTRSB8IEVfTk9USUNFICk7IC8vIEhJR0guCgpkZWZpbmUoICdQQl9TVEFOREFMT05FJywgdHJ1ZSApOwpkZWZpbmUoICdQQl9JTVBPUlRCVUREWScsIHRydWUgKTsKCnJlcXVpcmVfb25jZSBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2ltcG9ydGJ1ZGR5LWhvb2tzLnBocCc7Cml0X2J1Yl9pbXBvcnRidWRkeV9kb19hY3Rpb24oICdpbml0JyApOwoKJHBsdWdpbmJ1ZGR5X3NldHRpbmdzID0gaXRfYnViX2ltcG9ydGJ1ZGR5X2FwcGx5X2ZpbHRlcnMoICdwbHVnaW5idWRkeV9zZXR0aW5ncycsIGFycmF5KAoJJ3NsdWcnICAgICAgICAgICAgICAgICAgICA9PiAnYmFja3VwYnVkZHknLAoJJ3BocF9taW5pbXVtJyAgICAgICAgICAgICA9PiAnNS4yJywKCSdzZXJpZXMnICAgICAgICAgICAgICAgICAgPT4gJycsCgkncmVtb3RlX2FwaScgICAgICAgICAgICAgID0+ICcwJywgLy8gU2V0IHRvIDEgYnkgc3RhdGUgZm9yIGRlcGxveW1lbnRzLgoJJ2RlZmF1bHRfc3RhdGVfb3ZlcnJpZGVzJyA9PiBhcnJheSgpLCAvLyBEZWZhdWx0IHN0YXRlIHRvIG92ZXJyaWRlIHRoZSBtYWluIGRlZmF1bHRzLiBHb29kIGZvciBhdXRvbWF0aW5nIGltcG9ydHMuIEFwcGxpZWQgb3ZlciBkZWZhdWx0cyBkdXJpbmcgY29uc3RydWN0aW9uIG9mIHJlc3RvcmUgY2xhc3MuCgknZGVmYXVsdF9vcHRpb25zJyAgICAgICAgID0+IGFycmF5KAoJCSdiYl92ZXJzaW9uJyAgICAgICA9PiBQQl9CQl9WRVJTSU9OLCAgLy8gQkIgdmVyc2lvbiB0byBiZSBmaWxsZWQgaW4gb24gZG93bmxvYWQuCgkJJ2JhY2t1cF9kaXJlY3RvcnknID0+ICcnLAoJCSdsb2dfbGV2ZWwnICAgICAgICA9PiAwLCAvLyBObyBsb25nZXIgdXNpbmcgdGhpcyBtZXRob2QgZm9yIGhhbmRsaW5nIGxvZ2dpbmcuIHN0YXR1cygpIG1ldGhvZCBhbHdheXMgbG9ncyBhbGwgaWYgaW1wb3J0YnVkZHkuCgkpLAoJJ21vZHVsZXMnICAgICAgICAgICAgICAgICA9PiBhcnJheSgKCQkndXBkYXRlcicgICAgPT4gZmFsc2UsICAgICAgICAgICAgICAgICAgICAgIC8vIExvYWQgUGx1Z2luQnVkZHkgYXV0b21hdGljIHVwZ3JhZGVzLgoJCSdmaWxlc3lzdGVtJyA9PiB0cnVlLCAgICAgICAgICAgICAgICAgICAgICAgLy8gRmlsZSBzeXN0ZW0gaGVscGVyIG1ldGhvZHMuCgkJJ2Zvcm1hdCcgICAgID0+IHRydWUsICAgICAgICAgICAgICAgICAgICAgICAvLyBUZXh0IC8gZGF0YSBmb3JtYXR0aW5nIGhlbHBlciBtZXRob2RzLgoJKSwKKSApOwoKLy8gJHNldHRpbmdzIGlzIGV4cGVjdGVkIHRvIGJlIHBvcHVsYXRlZCBwcmlvciB0byBpbmNsdWRpbmcgUGx1Z2luQnVkZHkgZnJhbWV3b3JrLiBEbyBub3QgZWRpdCBiZWxvdy4KcmVxdWlyZSBkaXJuYW1lKCBfX0ZJTEVfXyApIC4gJy9wbHVnaW5idWRkeS9fcGx1Z2luYnVkZHkucGhwJzsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init.php,importbuddy/init.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWQoKTsKCi8vICoqKioqKioqKiogQUNUSU9OUyAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBBSkFYIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIERBU0hCT0FSRCAoYWRtaW4pICoqKioqKioqKioKCgoKLy8gKioqKioqKioqKiBGSUxURVJTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIFBBR0VTIChhZG1pbikgKioqKioqKioqKgoKCgovLyAqKioqKioqKioqIExJQlJBUklFUyAmIENMQVNTRVMgKGFkbWluKSAqKioqKioqKioqCnJlcXVpcmVfb25jZSggJ2NsYXNzZXMvY29yZS5waHAnICk7CgpyZXF1aXJlX29uY2UoICdjbGFzc2VzL2ltcG9ydC5waHAnICk7CnBiX2JhY2t1cGJ1ZGR5OjokY2xhc3Nlc1snaW1wb3J0J10gPSBuZXcgcGJfYmFja3VwYnVkZHlfaW1wb3J0KCk7CgoKLy8gKioqKioqKioqKiBPVEhFUiAoYWRtaW4pICoqKioqKioqKioKCgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_admin.php,importbuddy/init_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
PD9waHAKLyoqCiAqIEluaXQgR2xvYmFsCiAqCiAqIEBwYWNrYWdlIEJhY2t1cEJ1ZGR5CiAqLwoKaWYgKCAhIGNsYXNzX2V4aXN0cyggJ2JhY2t1cGJ1ZGR5X2NvcmUnICkgKSB7CglyZXF1aXJlX29uY2UgcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2NsYXNzZXMvY29yZS5waHAnOwp9CgpyZXF1aXJlX29uY2UgQUJTUEFUSCAuICdpbXBvcnRidWRkeS9jbGFzc2VzL2F1dGgucGhwJzsKCi8vIElmIHZlcmlmaWNhdGlvbiBjb2RlIHBhc3NlZCB0aGVuIGF1dGhlbnRpY2F0ZSBlYXJseS4KaWYgKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2Rpc3BsYXlfbW9kZScgKSA9PSAnZW1iZWQnICkgewoJQXV0aDo6cmVxdWlyZV9hdXRoZW50aWNhdGlvbigpOwp9CgpnbG9iYWwgJGltcG9ydGJ1ZGR5X2ZpbGU7CiRpbXBvcnRfc2VyaWFsID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0X3NlcmlhbF9mcm9tX2ZpbGUoICRpbXBvcnRidWRkeV9maWxlICk7CgppZiAoICcnICE9ICRpbXBvcnRfc2VyaWFsICkgeyAvLyBpbXBvcnRidWRkeSBoYXMgYSBzZXJpYWwuIExvb2sgZm9yIGEgZGVmYXVsdCBzdGF0ZSBmaWxlIHRoYXQgbWF0Y2hlcy4KCXBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1snbG9nX3NlcmlhbCddID0gJGltcG9ydF9zZXJpYWw7CglwYl9iYWNrdXBidWRkeTo6c2F2ZSgpOwoKCWlmICggZmlsZV9leGlzdHMoIEFCU1BBVEggLiAnaW1wb3J0YnVkZHktJyAuICRpbXBvcnRfc2VyaWFsIC4gJy1zdGF0ZS5waHAnICkgKSB7IC8vIERlZmF1bHQgc3RhdGUgZXhpc3RzLgoKCQkvLyBJZiBhbiBvdmVycmlkaW5nIHN0YXRlIGZpbGUgZXhpc3RzIHRoZW4gbG9hZCBpdCBvdmVyIHRoZSBjdXJyZW50IHN0YXRlLgoJCSRvdmVycmlkZV9zdGF0ZV9maWxlID0gQUJTUEFUSCAuICdpbXBvcnRidWRkeS0nIC4gJGltcG9ydF9zZXJpYWwgLiAnLXN0YXRlLnBocCc7CgkJaWYgKCBmaWxlX2V4aXN0cyggJG92ZXJyaWRlX3N0YXRlX2ZpbGUgKSApIHsKCQkJJHN0YXRlZGF0YSA9IGZpbGVfZ2V0X2NvbnRlbnRzKCAkb3ZlcnJpZGVfc3RhdGVfZmlsZSApOwoJCQkvLyBTa2lwIGZpcnN0IGxpbmUuCgkJCSRzZWNvbmRfbGluZV9wb3MgPSBzdHJwb3MoICRzdGF0ZWRhdGEsICJcbiIgKSArIDE7CgkJCSRzdGF0ZWRhdGEgICAgICAgPSBzdWJzdHIoICRzdGF0ZWRhdGEsICRzZWNvbmRfbGluZV9wb3MgKTsKCQkJLy8gRGVjb2RlIGJhY2sgaW50byBhbiBhcnJheS4KCQkJJHN0YXRlZGF0YSA9IGpzb25fZGVjb2RlKCBiYXNlNjRfZGVjb2RlKCAkc3RhdGVkYXRhICksIHRydWUgKTsKCQkJaWYgKCBpc19hcnJheSggJHN0YXRlZGF0YSApICkgeyAvLyBWYWxpZCBjb250ZW50LgoJCQkJLy8gTm9ybWFsaXplIFVSTHMuCgkJCQlpZiAoIGlzc2V0KCAkc3RhdGVkYXRhWydzaXRldXJsJ10gKSApIHsKCQkJCQkkc3RhdGVkYXRhWydzaXRldXJsJ10gPSBydHJpbSggJHN0YXRlZGF0YVsnc2l0ZXVybCddLCAnLycgKTsKCQkJCX0KCQkJCWlmICggaXNzZXQoICRzdGF0ZWRhdGFbJ2hvbWV1cmwnXSApICkgewoJCQkJCSRzdGF0ZWRhdGFbJ2hvbWV1cmwnXSA9IHJ0cmltKCAkc3RhdGVkYXRhWydob21ldXJsJ10sICcvJyApOwoJCQkJfQoKCQkJCXBiX2JhY2t1cGJ1ZGR5OjpzdGF0dXMoICdkZXRhaWxzJywgJ0xvYWRlZCBkZWZhdWx0IHN0YXRlIG92ZXJyaWRlIHN0YXRlIGZpbGUgZGF0YSBhbmQgZ2F2ZSBpdCBwcmlvcml0eSBvdmVyIGN1cnJlbnQgc3RhdGUuIEZpbGU6IGAnIC4gJG92ZXJyaWRlX3N0YXRlX2ZpbGUgLiAnYC4nICk7CgkJCQlwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnNbJ2RlZmF1bHRfc3RhdGVfb3ZlcnJpZGVzJ10gPSAkc3RhdGVkYXRhOwoJCQkJcGJfYmFja3VwYnVkZHk6OnNhdmUoKTsKCQkJfQoJCX0KCX0gZWxzZSB7CgkJcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnT3ZlcnJpZGUgc3RhdGUgZmlsZSBub3QgZm91bmQgYXQgYCcgLiAkb3ZlcnJpZGVfc3RhdGVfZmlsZSAuICdgLiBTa2lwcGluZy4nICk7Cgl9Cn0KCi8vIEhhbmRsZSBBUEkgY2FsbHMgaWYgYmFja3VwYnVkZHlfYXBpX2tleSBpcyBwb3N0ZWQuIElmIGFueXRoaW5nIGZhaWxzIHNlY3VyaXR5IGNoZWNrcyBwcmV0ZW5kIG5vdGhpbmcgYXQgYWxsIGhhcHBlbmVkLgppZiAoICcnICE9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2JhY2t1cGJ1ZGR5X2FwaV9rZXknICkgKSB7IC8vIFJlbW90ZSBBUEkgYWNjZXNzLgoJaWYgKCBpc3NldCggcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydyZW1vdGVfYXBpJ11bJ2tleXMnXSApICYmICggY291bnQoIHBiX2JhY2t1cGJ1ZGR5Ojokb3B0aW9uc1sncmVtb3RlX2FwaSddWydrZXlzJ10gKSA+IDAgKSApIHsgLy8gUmVtb3RlIEFQSSBlbmFibGVkIGFuZCAxIG9yIG1vcmUga2V5cyBkZWZpbmVkLgoJCWluY2x1ZGUgJ2NsYXNzZXMvcmVtb3RlX2FwaS5waHAnOwoJCWJhY2t1cGJ1ZGR5X3JlbW90ZV9hcGk6OmxvY2FsQ2FsbCggdHJ1ZSwgdHJ1ZSApOwoJCWRpZSgpOwoJfQp9CgppZiAoICdlbWJlZCcgPT09IHBiX2JhY2t1cGJ1ZGR5OjpfR0VUKCAnZGlzcGxheV9tb2RlJyApICkgewoJcGJfYmFja3VwYnVkZHk6OiRvcHRpb25zWydkaXNwbGF5X21vZGUnXSA9ICdlbWJlZCc7CglwYl9iYWNrdXBidWRkeTo6c2F2ZSgpOwp9Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/init_global.php,importbuddy/init_global.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/license.txt,importbuddy/license.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
ICogV2Vic2l0ZTogaHR0cDovL2l0aGVtZXMuY29tCiAqCiAqIEluc3RhbGxhdGlvbjoKICogCiAqIDEuIERvd25sb2FkIGFuZCB1bnppcCB0aGUgbGF0ZXN0IHJlbGVhc2UgemlwIGZpbGUKICogMi4gSWYgeW91IHVzZSB0aGUgV29yZFByZXNzIHBsdWdpbiB1cGxvYWRlciB0byBpbnN0YWxsIHRoaXMgcGx1Z2luIHNraXAgdG8gc3RlcCA0LgogKiAzLiBVcGxvYWQgdGhlIGVudGlyZSBwbHVnaW4gZGlyZWN0b3J5IHRvIHlvdXIgYC93cC1jb250ZW50L3BsdWdpbnMvYCBkaXJlY3RvcnkKICogNC4gQWN0aXZhdGUgdGhlIHBsdWdpbiB0aHJvdWdoIHRoZSAnUGx1Z2lucycgbWVudSBpbiBXb3JkUHJlc3MgQWRtaW5pc3RyYXRpb24KICogCiAqIFVzYWdlOgogKiAKICogMS4gTmF2aWdhdGUgdG8gdGhlIG5ldyBtZW51IGZvciB0aGlzIHBsdWdpbiBpbiB0aGUgV29yZHByZXNzIEFkbWluaXN0cmF0aW9uIFBhbmVsCiAqIDIuIFNlbGVjdCAnR2V0dGluZyBTdGFydGVkJyBmb3IgaW5zdHJ1Y3Rpb25zIGFuZCBhZGRpdGlvbmFsIGluZm9ybWF0aW9uLgogKg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/readme.txt,importbuddy/readme.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/sample.ini.txt,importbuddy/sample.ini.txt
OyBEZWZhdWx0IHZhbHVlcyBjYW4gYmUgc2VlbiBpbjogaW1wb3J0YnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCAob3IgYmFja3VwYnVkZHkvY2xhc3Nlcy9yZXN0b3JlLnBocCkgaW4gdGhlIF9fY29uc3RydWN0KCkgZnVuY3Rpb24sIHdoZXJlICR0aGlzLT5fc3RhdGUgaXMgZmlyc3Qgc2V0LgoKdHlwZSA9IHJlc3RvcmUKYXJjaGl2ZSA9IGJhY2t1cC1iYWNrdXBidWRkeS1YWFhYWFhYWFhYWC56aXAKc2l0ZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KaG9tZXVybCA9IGh0dHA6Ly9maW5hbHVybC5jb20KcmVzdG9yZUZpbGVzID0gdHJ1ZQpyZXN0b3JlRGF0YWJhc2UgPSB0cnVlCm1pZ3JhdGVIdGFjY2VzcyA9IHRydWUKCjsgQm90aCBvZiB0aGVzZSBtdXN0IGJlIHRydWUgd2hlbiB1c2luZyAuaW5pIGZpbGUuCmluaW1vZGUgPSB0cnVlCmF1dG9BZHZhbmNlID0gdHJ1ZQoKW2RhdGFiYXNlU2V0dGluZ3NdCnNlcnZlciA9IGxvY2FsaG9zdApkYXRhYmFzZSA9IGRhdGFiYXNlX25hbWUKdXNlcm5hbWUgPSBkYXRhYmFzZV91c2VyCnBhc3N3b3JkID0gZGF0YWJhc2VfcGFzc3dvcmQKcHJlZml4ID0gd3BfCnJlbmFtZVByZWZpeCA9IHRydWUKd2lwZVByZWZpeCA9IGZhbHNlCndpcGVEYXRhYmFzZSA9IGZhbHNlCgpbY2xlYW51cF0KZGVsZXRlQXJjaGl2ZSA9IGZhbHNlCmRlbGV0ZVRlbXBGaWxlcyA9IHRydWUKZGVsZXRlSW1wb3J0QnVkZHkgPSBmYWxzZQpzZXRfYmxvZ19wdWJsaWMgPSAKZGVsZXRlSW1wb3J0QnVkZHlEaXJlY3RvcnkgPSB0cnVlCmRlbGV0ZUltcG9ydExvZyA9IHRydWUK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/sample.ini.txt,importbuddy/sample.ini.txt
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/auth.php,importbuddy/classes/auth.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/test-db.php,importbuddy/classes/test-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/classes/wp-db.php,importbuddy/classes/wp-db.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
PD9waHAKY2xhc3MgcGJfYmFja3VwYnVkZHlfYWpheCBleHRlbmRzIHBiX2JhY2t1cGJ1ZGR5X2FqYXhjb3JlIHsKfQ==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax.php,importbuddy/controllers/ajax.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
PD9waHAKcGJfYmFja3VwYnVkZHk6OmxvYWRfc3R5bGUoICdpbXBvcnRidWRkeS5jc3MnICk7CnBiX2JhY2t1cGJ1ZGR5Ojpsb2FkX3N0eWxlKCAncGx1Z2luYnVkZHkuY3NzJyApOwpwYl9iYWNrdXBidWRkeTo6bG9hZF9zY3JpcHQoICdpbXBvcnRidWRkeS5qcycgKTsKcGJfYmFja3VwYnVkZHk6OmxvYWRfc2NyaXB0KCAncGx1Z2luYnVkZHkuanMnICk7Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_assets.php,importbuddy/views/_assets.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_dbreplace.php,importbuddy/views/_dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9Cj8+Cgo8L2Rpdj4KPC9kaXY+CgoKPC9ib2R5Pgo8L2h0bWw+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_footer.php,importbuddy/views/_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_header.php,importbuddy/views/_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_html_1_stash.php,importbuddy/views/_html_1_stash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
CTxzY3JpcHQ+Ly9iYl9hY3Rpb24oICdpZnJhbWVMb2FkZWQnICk7PC9zY3JpcHQ+CjwvaHRtbD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_footer.php,importbuddy/views/_iframe_footer.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
PGh0bWw+Cjw/cGhwCnJlcXVpcmUoICdfYXNzZXRzLnBocCcgKTsKCgoKaWYgKCAndHJ1ZScgIT0gcGJfYmFja3VwYnVkZHk6Ol9HRVQoICdkZXBsb3knICkgKSB7IC8vIE5PUk1BTCwgTk9UIERFUExPWU1FTlQuCj8+Cgk8c2NyaXB0PgoJCXZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCXdpbi53aW5kb3cuc2Nyb2xsVG8oMCwwKTsKCQkKCQlmdW5jdGlvbiBwYl9zdGF0dXNfYXBwZW5kKCBzdGF0dXNfc3RyaW5nICkgewoJCQkvL3ZhciB3aW4gPSB3aW5kb3cuZGlhbG9nQXJndW1lbnRzIHx8IG9wZW5lciB8fCBwYXJlbnQgfHwgdG9wOwoJCQl3aW4ucGJfc3RhdHVzX2FwcGVuZCggc3RhdHVzX3N0cmluZyApOwoJCX0KCQlmdW5jdGlvbiBwYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKSB7CgkJCS8vdmFyIHdpbiA9IHdpbmRvdy5kaWFsb2dBcmd1bWVudHMgfHwgb3BlbmVyIHx8IHBhcmVudCB8fCB0b3A7CgkJCXdpbi5wYl9zdGF0dXNfdW5kb3VybCggdW5kb191cmwgKTsKCQl9CgkJCgkJCgkJCgkJZnVuY3Rpb24gcGFnZVRpdGxlKCB0aXRsZSApIHsKCQkJCgkJCXdpbi5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoIHRpdGxlICk7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX2FjdGlvbiggYWN0aW9uLCBub3RlICkgewoJCQl3aW4uYmJfYWN0aW9uKCBhY3Rpb24sIG5vdGUgKTsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJCXdpbi5iYl9yZXN0b3JlRGF0YSggZGF0YSApOwoJCX0KCQkKCQlmdW5jdGlvbiBiYl9zaG93U3RlcCggc3RlcCwgZGF0YSApIHsKCQkJd2luLmJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICk7CgkJfQoJCQoJPC9zY3JpcHQ+Cjw/cGhwIH0gZWxzZSB7IC8vIERFUExPWU1FTlQgPz4KCTxzY3JpcHQ+CgkJZnVuY3Rpb24gcGJfc3RhdHVzX2FwcGVuZCgpIHsKCQl9CgkJCgkJZnVuY3Rpb24gcGJfc3RhdHVzX3VuZG91cmwoIHVuZG9fdXJsICkgewoJCX0KCQkKCQlmdW5jdGlvbiBwYWdlVGl0bGUoIHRpdGxlICkgewoJCX0KCQkKCQlmdW5jdGlvbiBiYl9hY3Rpb24oIGFjdGlvbiwgbm90ZSApIHsKCQl9CgkJCgkJZnVuY3Rpb24gYmJfcmVzdG9yZURhdGEoIGRhdGEgKSB7CgkJfQoJCQoJCWZ1bmN0aW9uIGJiX3Nob3dTdGVwKCBzdGVwLCBkYXRhICkgewoJCX0KCTwvc2NyaXB0Pgo8P3BocCB9ID8+
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/_iframe_header.php,importbuddy/views/_iframe_header.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/cleanupSettings.htm,importbuddy/views/cleanupSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/databaseSettings.htm,importbuddy/views/databaseSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgokcGFnZV90aXRsZSA9ICdEYXRhYmFzZSBUZXh0IFJlcGxhY2UgVG9vbCc7CnJlcXVpcmVfb25jZSggJ19oZWFkZXIucGhwJyApOwo/PgoKPGRpdiBjbGFzcz0id3JhcCI+Cjw/cGhwCiRjb25maWdGaWxlID0gJyc7CmlmICggISBmaWxlX2V4aXN0cyggQUJTUEFUSCAuICd3cC1jb25maWcucGhwJyApICkgeyAvLyBOb3JtYWwgY29uZmlnIGZpbGUgbm90IGZvdW5kIHNvIHdhcm4gb3Igc2VlIGlmIHBhcmVudCBjb25maWcgbWF5IGV4aXN0LgoJJHBhcmVudENvbmZpZ01lc3NhZ2UgPSAnJzsKCSRwYXJlbnRDb25maWcgPSAgZGlybmFtZSggQUJTUEFUSCApIC4gJy93cC1jb25maWcucGhwJzsKCWlmICggQGZpbGVfZXhpc3RzKCAkcGFyZW50Q29uZmlnICkgKSB7IC8vIFBhcmVudCBjb25maWcgZXhpc3RzIHNvIG9mZmVyIGl0IGFzIGFuIG9wdGlvbiBvciBwb3NzaWJseSB1c2UgaXQgaWYgdXNlciBoYXMgc2VsZWN0ZWQgdG8gZG8gc28uCgkJaWYgKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ3BhcmVudF9jb25maWcnICkgPT0gJ3RydWUnICkgeyAvLyBVc2VyIG9wdGVkIHRvIHVzZSBwYXJlbnQgY29uZmlnLgoJCQkkY29uZmlnRmlsZSA9ICRwYXJlbnRDb25maWc7CgkJfSBlbHNlIHsgLy8gVXNlciBoYXMgbm90IG9wdGVkIHRvIHVzZSBwYXJlbnQgY29uZmlnIHlldCBzbyBzZXQgbWVzc2FnZSB0byBvZmZlciBpdC4KCQkJJHBhcmVudENvbmZpZ01lc3NhZ2UgPSAnPGJyPjxicj48Yj5Ib3dldmVyPC9iPiwgYSB3cC1jb25maWcucGhwIGZpbGUgd2FzIGZvdW5kIGluIHRoZSBwYXJlbnQgZGlyZWN0b3J5IGFzIGAnIC4gJHBhcmVudENvbmZpZyAuICdgLiA8YSBocmVmPSI/cGFnZT1kYnJlcGxhY2UmcGFyZW50X2NvbmZpZz10cnVlIj48Yj5DbGljayBoZXJlPC9iPjwvYT4gaWYgeW91IHdvdWxkIGxpa2UgdG8gcnVuIHRoaXMgdG9vbCB1c2luZyB0aGlzIHdwLWNvbmZpZy5waHAgZmlsZSBpbiB0aGUgcGFyZW50IGRpcmVjdG9yeS4nOwoJCX0KCX0KCWlmICggJycgPT0gJGNvbmZpZ0ZpbGUgKSB7CgkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCAnPGI+RXJyb3I6PC9iPiBUaGlzIHRvb2wgcmVxdWlyZXMgYW4gZXhpc3RpbmcgV29yZFByZXNzIGluc3RhbGxhdGlvbiB0byBwZXJmb3JtIGRhdGFiYXNlIHJlcGxhY2VtZW50cyBvbi4gTm8gV29yZFByZXNzIHdwLWNvbmZpZy5waHAgY29uZmlndXJhdGlvbiBmaWxlIHdhcyBmb3VuZCBpbiB0aGUgc2FtZSBkaXJlY3RvcnkgYXMgaW1wb3J0YnVkZHkucGhwLiAnIC4gJHBhcmVudENvbmZpZ01lc3NhZ2UgLiAnPC9wPjxwPjxiPk5vdGU6PC9iPiBUaGUgSW1wb3J0ZXIgYXV0b21hdGljYWxseSBoYW5kbGVzIG1pZ3JhdGluZyAmIHJlcGxhY2luZyB5b3VyIHNpdGUgVVJMcyBhbmQgZmlsZSBwYXRocyBkdXJpbmcgcmVzdG9yZS9taWdyYXRpb247IHRoaXMgdG9vbCBpcyBub3QgbmVlZGVkIGZvciBub3JtYWwgYmFja3VwIC8gcmVzdG9yZSBvcGVyYXRpb25zLicsIHRydWUgKTsKCX0KfSBlbHNlIHsgLy8gVXNlIG5vcm1hbCBjb25maWcgZmlsZS4KCSRjb25maWdGaWxlID0gQUJTUEFUSCAuICd3cC1jb25maWcucGhwJzsKfQoKaWYgKCAnJyAhPSAkY29uZmlnRmlsZSApIHsKCgkvLyBSZWFkIGluIHdwLWNvbmZpZy5waHAgZmlsZSBjb250ZW50cy4KCSRjb25maWdDb250ZW50cyA9IGZpbGVfZ2V0X2NvbnRlbnRzKCAkY29uZmlnRmlsZSApOwoJaWYgKCBmYWxzZSA9PT0gJGNvbmZpZ0NvbnRlbnRzICkgewoJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0Vycm9yOiBVbmFibGUgdG8gcmVhZCB3cC1jb25maWcucGhwIGNvbmZpZ3VyYXRpb24gZmlsZS4nICk7CgkJcmV0dXJuOwoJfQoKCS8vIEdyYWIgZGF0YWJhc2Ugc2V0dGluZ3MgZnJvbSB3cC1jb25maWcucGhwIGNvbnRlbnRzLgoJcHJlZ19tYXRjaCggJy9kZWZpbmVcKFtcc10qKFwnfCIpREJfTkFNRShcJ3wiKSxbXHNdKihcJ3wiKSguKikoXCd8IilbXHNdKlwpOy9pJywgJGNvbmZpZ0NvbnRlbnRzLCAkbWF0Y2hlcyApOwoJJGRhdGFiYXNlU2V0dGluZ3NbJ25hbWUnXSA9ICRtYXRjaGVzWzRdOwoJcHJlZ19tYXRjaCggJy9kZWZpbmVcKFtcc10qKFwnfCIpREJfVVNFUihcJ3wiKSxbXHNdKihcJ3wiKSguKikoXCd8IilbXHNdKlwpOy9pJywgJGNvbmZpZ0NvbnRlbnRzLCAkbWF0Y2hlcyApOwoJJGRhdGFiYXNlU2V0dGluZ3NbJ3VzZXJuYW1lJ10gPSAkbWF0Y2hlc1s0XTsKCXByZWdfbWF0Y2goICcvZGVmaW5lXChbXHNdKihcJ3wiKURCX1BBU1NXT1JEKFwnfCIpLFtcc10qKFwnfCIpKC4qKShcJ3wiKVtcc10qXCk7L2knLCAkY29uZmlnQ29udGVudHMsICRtYXRjaGVzICk7CgkkZGF0YWJhc2VTZXR0aW5nc1sncGFzc3dvcmQnXSA9ICRtYXRjaGVzWzRdOwoJcHJlZ19tYXRjaCggJy9kZWZpbmVcKFtcc10qKFwnfCIpREJfSE9TVChcJ3wiKSxbXHNdKihcJ3wiKSguKikoXCd8IilbXHNdKlwpOy9pJywgJGNvbmZpZ0NvbnRlbnRzLCAkbWF0Y2hlcyApOwoJJGRhdGFiYXNlU2V0dGluZ3NbJ2hvc3QnXSA9ICRtYXRjaGVzWzRdOwoJcHJlZ19tYXRjaCggJy9cJHRhYmxlX3ByZWZpeFtcc10qPVtcc10qKFwnfCIpKC4qKShcJ3wiKTsvaScsICRjb25maWdDb250ZW50cywgJG1hdGNoZXMgKTsKCSRkYXRhYmFzZVNldHRpbmdzWydwcmVmaXgnXSA9ICRtYXRjaGVzWzJdOwoKCS8vcHJpbnRfciggJGRhdGFiYXNlU2V0dGluZ3MgKTsKCgkvLyBDb25uZWN0IHRvIGRhdGFiYXNlLgoJZ2xvYmFsICR3cGRiOwoJJHdwZGIgPSBuZXcgd3BkYiggJGRhdGFiYXNlU2V0dGluZ3NbJ3VzZXJuYW1lJ10sICRkYXRhYmFzZVNldHRpbmdzWydwYXNzd29yZCddLCAkZGF0YWJhc2VTZXR0aW5nc1snbmFtZSddLCAkZGF0YWJhc2VTZXR0aW5nc1snaG9zdCddICk7CglpZiAoIGZhbHNlID09PSAkd3BkYi0+ZGJoICkgewoJCXBiX2JhY2t1cGJ1ZGR5OjphbGVydCggJ0Vycm9yICM4NTgzODM6IFVuYWJsZSB0byBjb25uZWN0IHRvIGRhdGFiYXNlIHVzaW5nIHNldHRpbmdzIGluIHdwLWNvbmZpZy5waHAuIFZlcmlmeSBjb25uZWN0aW9uIHNldHRpbmdzLicgKTsKCX0gZWxzZSB7CgkJcmVxdWlyZV9vbmNlKCAnX2RicmVwbGFjZS5waHAnICk7Cgl9Cn0KPz4KPC9kaXY+Cgo8P3BocApyZXF1aXJlX29uY2UoICdfZm9vdGVyLnBocCcgKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/dbreplace.php,importbuddy/views/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
VGhpcyBzdGVwIGhhbmRsZXMgZGVsZXRpbmcgZmlsZXMuIEluIHJhcmUgaW5zdGFuY2VzIG9uIHNvbWUgc2VydmVycyB5b3UgbWF5IHJlY2VpdmUgZXJyb3JzIGxvYWRpbmcgZmlsZXMgb3IgYW4gdW5zdHlsZWQgcGFnZSBoZXJlIGR1ZSB0byBmaWxlcyBnZXR0aW5nIGRlbGV0aW5nIHByZW1hdHVyZWx5IGJlZm9yZSB0aGUgcGFnZSBjb21wbGV0ZXMgbG9hZGluZy4gVGhpcyBtYXkgc2FmZWx5IGJlIGlnbm9yZWQuIEl0IGlzIGNvbW1vbiB0byBub3QgYmUgYWJsZSB0byBkZWxldGUgc29tZSBmaWxlcyBkdWUgdG8gcGVybWlzc2lvbiBlcnJvcnMuIFlvdSBtYXkgbWFudWFsbHkgZGVsZXRlIHRoZW0uIDxiPmltcG9ydGJ1ZGR5LnBocDwvYj4gc2hvdWxkIGFsd2F5cyBiZSBkZWxldGVkIGFmdGVyIHJlc3RvcmUgZm9yIGJlc3Qgc2VjdXJpdHkuCgo8aDMgc3R5bGU9InRleHQtYWxpZ246IGNlbnRlcjsiPllvdXIgc2l0ZSBpcyByZWFkeSB0byBnbyBhdAo8YSBocmVmPSI8JT1ob21ldXJsJT4iIHRhcmdldD0iX2JsYW5rIj48Yj48JT1ob21ldXJsJT48L2I+PC9hPjxicj48YnI+ClRoYW5rIHlvdSBmb3IgY2hvb3NpbmcgU29saWQgQmFja3VwcyE8L2gzPgoKCjwvZGl2PjwvZGl2Pjxicj48YnI+PGJyPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finalCleanup.htm,importbuddy/views/finalCleanup.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
PGgzPlJlc3RvcmUgRmluaXNoZWQhPC9oMz4KCjxoMz5Zb3VyIHNpdGUgc2hvdWxkIGJlIHJlYWR5IHRvIGdvIGF0PGJyPjxhIGhyZWY9IjwlPWhvbWV1cmwlPiIgdGFyZ2V0PSJfYmxhbmsiPjwlPWhvbWV1cmwlPjwvYT48L2gzPgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/finished.htm,importbuddy/views/finished.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
PD9waHAKLyoqCiAqIEltcG9ydGVyIEhvbWUgVmlldwogKgogKiBAcGFja2FnZSBCYWNrdXBCdWRkeQogKi8KCmlmICggISBkZWZpbmVkKCAnUEJfSU1QT1JUQlVERFknICkgfHwgKCB0cnVlICE9PSBQQl9JTVBPUlRCVUREWSApICkgewoJZGllKCAnPGh0bWw+PC9odG1sPicgKTsKfQo/Pgo8c2NyaXB0PgoJalF1ZXJ5KCAnI3BhZ2VUaXRsZScgKS5odG1sKCAnU3RlcCAxOiBTZWxlY3QgQmFja3VwIHRvIFJlc3RvcmUnICk7CgoJZnVuY3Rpb24gYmFja3VwUmVzdG9yZVN1Z2dlc3QoIGJhY2t1cFR5cGUgKSB7CgkJaWYgKCAnZGInID09IGJhY2t1cFR5cGUgKSB7IC8vIERCIGhhcyBubyBmaWxlcyAoZXhjZXB0IFNRTCBvZiBjb3Vyc2UpIHNvIHNraXAgcm9vdCBmaWxlIGV4dHJhY3Rpb24uCgkJCWpRdWVyeSggJ2lucHV0W25hbWU9InJlc3RvcmVGaWxlcyJdJyApLnByb3AoICdjaGVja2VkJywgZmFsc2UgKS5hdHRyKCAnZGlzYWJsZWQnLCB0cnVlICk7CgkJCWpRdWVyeSggJ2lucHV0W25hbWU9InJlc3RvcmVEYXRhYmFzZSJdJyApLnByb3AoICdjaGVja2VkJywgdHJ1ZSApLmF0dHIoICdkaXNhYmxlZCcsIGZhbHNlICk7CgkJfSBlbHNlIGlmICggJ2ZpbGVzJyA9PSBiYWNrdXBUeXBlICkgeyAvLyBGaWxlcyBoYXMgbm8gREIgc28gZGlzYWJsZSBEQi4KCQkJalF1ZXJ5KCAnaW5wdXRbbmFtZT0icmVzdG9yZUZpbGVzIl0nICkucHJvcCggJ2NoZWNrZWQnLCB0cnVlICkuYXR0ciggJ2Rpc2FibGVkJywgZmFsc2UgKTsKCQkJalF1ZXJ5KCAnaW5wdXRbbmFtZT0icmVzdG9yZURhdGFiYXNlIl0nICkucHJvcCggJ2NoZWNrZWQnLCBmYWxzZSApLmF0dHIoICdkaXNhYmxlZCcsIHRydWUgKTsKCQl9IGVsc2UgeyAvLyBkZWZhdWx0IHJlc3RvcmUgYWxsCgkJCWpRdWVyeSggJ2lucHV0W25hbWU9InJlc3RvcmVGaWxlcyJdJyApLnByb3AoICdjaGVja2VkJywgdHJ1ZSApLmF0dHIoICdkaXNhYmxlZCcsIGZhbHNlICk7CgkJCWpRdWVyeSggJ2lucHV0W25hbWU9InJlc3RvcmVEYXRhYmFzZSJdJyApLnByb3AoICdjaGVja2VkJywgdHJ1ZSApLmF0dHIoICdkaXNhYmxlZCcsIGZhbHNlICk7CgkJfQoJfQoKCWpRdWVyeShkb2N1bWVudCkucmVhZHkoZnVuY3Rpb24oKSB7CgkJalF1ZXJ5KCAnLnNlbGVjdGFibGVCYWNrdXBBcmNoaXZlJyApLmNsaWNrKCBmdW5jdGlvbigpewoJCQliYWNrdXBUeXBlID0galF1ZXJ5KHRoaXMpLmF0dHIoICdkYXRhLXR5cGUnICk7CgkJCWJhY2t1cFJlc3RvcmVTdWdnZXN0KCBiYWNrdXBUeXBlICk7CgkJfSk7CgoJCXN0YXJ0aW5nQmFja3VwVHlwZSA9IGpRdWVyeSggJy5zZWxlY3RhYmxlQmFja3VwQXJjaGl2ZTpjaGVja2VkJyApLmF0dHIoICdkYXRhLXR5cGUnICk7CgkJYmFja3VwUmVzdG9yZVN1Z2dlc3QoIHN0YXJ0aW5nQmFja3VwVHlwZSApOwoJfSk7Cjwvc2NyaXB0PgoKPD9waHAKZWNobyAnPGRpdiBjbGFzcz0ic3RlcC13cmFwIHN0ZXAtc2VsZWN0QmFja3VwLXdyYXAiPic7CgovLyBEaXNwbGF5IHByZS1mbGlnaHQgc2NhbiB3YXJuaW5ncyAmIGVycm9ycy4KJHByZWZsaWdodFJlc3VsdHMgPSBwcmVmbGlnaHRTY2FuKCk7CmlmICggY291bnQoICRwcmVmbGlnaHRSZXN1bHRzICkgPiAwICkgewoJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KCBpbXBsb2RlKCAnPGhyPicsICRwcmVmbGlnaHRSZXN1bHRzICkgKTsKfQp1bnNldCggJHByZWZsaWdodFJlc3VsdHMgKTsKCi8vICRzdGVwID0gJzEnOwovLyBlY2hvICc8c2NyaXB0PnBhZ2VUaXRsZSggIlN0ZXAgPHNwYW4gY2xhc3M9XCJzdGVwX251bWJlclwiPicgLiAkc3RlcCAuICc8L3NwYW4+IG9mIDY6IENob29zZSB5b3VyIGJhY2t1cCBmaWxlIiApOzwvc2NyaXB0Pic7CmlmICggJ3N0YXNoJyA9PSBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ3VwbG9hZCcgKSApIHsKCXJlcXVpcmUgJ19odG1sXzFfc3Rhc2gucGhwJzsKCWVjaG8gJzwvZGl2Pic7CglyZXR1cm47Cn0KPz4KCjxkaXYgY2xhc3M9IndyYXAiPgoKPD9waHAKaWYgKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2ZpbGUnICkgIT0gJycgKSB7CgkkYmFja3VwX2FyY2hpdmVzID0gYXJyYXkoIHBiX2JhY2t1cGJ1ZGR5OjpfR0VUKCAnZmlsZScgKSApOwoJZWNobyAnPGRpdiBzdHlsZT0icGFkZGluZzogMTVweDsgYmFja2dyb3VuZDogI0ZGRkZGRjsiPlJlc3RvcmluZyBmcm9tIGJhY2t1cCA8aT4nIC4gaHRtbGVudGl0aWVzKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2ZpbGUnICkgKSAuICc8L2k+PC9kaXY+Cgk8Zm9ybSBhY3Rpb249Ij9hamF4PTIiIG1ldGhvZD0icG9zdCIgdGFyZ2V0PSJtaW5pRnJhbWUiPic7CgllY2hvICc8aW5wdXQgdHlwZT0iaGlkZGVuIiBuYW1lPSJmaWxlIiB2YWx1ZT0iJyAuIGVzY19hdHRyKCBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2ZpbGUnICkgKSAuICciPic7Cn0gZWxzZSB7Cgk/PgoKCTxkaXYgY2xhc3M9ImJhY2t1cF9zZWxlY3RfYnV0dG9ucyI+CgkJPGJ1dHRvbiBocmVmPSIjcGJfdXBsb2FkX21vZGFsIiBjbGFzcz0iYnV0dG9uIGJ1dHRvbi1zZWNvbmRhcnkgbGVhbk1vZGFsIGNyZWF0ZWRiX21vZGFsX2xpbmsiIHN0eWxlPSJmb250LXNpemU6IDE0cHg7Ij5VcGxvYWQgYSBCYWNrdXA8L2J1dHRvbj4KCQk8YnV0dG9uIGhyZWY9IiNwYl9zdGFzaF9tb2RhbCIgY2xhc3M9ImJ1dHRvbiBidXR0b24tc2Vjb25kYXJ5IGxlYW5Nb2RhbCBjcmVhdGVkYl9tb2RhbF9saW5rIiBzdHlsZT0iZm9udC1zaXplOiAxNHB4OyI+UmVzdG9yZSBmcm9tIFN0YXNoIC8gU3Rhc2ggTGl2ZTwvYnV0dG9uPgoJPC9kaXY+CgoJPD9waHAKCSRiYWNrdXBfYXJjaGl2ZXMgPSBnZXRfYXJjaGl2ZXNfbGlzdCgpOwoJaWYgKCAwID09IGNvdW50KCAkYmFja3VwX2FyY2hpdmVzICkgKSB7IC8vIE5vIGJhY2t1cHMgZm91bmQuCgoJCS8vIExvb2sgZm9yIG1hbnVhbGx5IHVuemlwcGVkCgkJcGJfYmFja3VwYnVkZHk6OmFsZXJ0KAoJCQknPGI+Tm8gU29saWQgQmFja3VwcyBaaXAgYmFja3VwIGZvdW5kIGluIHRoaXMgZGlyZWN0b3J5IGAnIC4gQUJTUEFUSCAuICdgPC9iPiAtCgkJCVlvdSBtdXN0IHVwbG9hZCBhIGJhY2t1cCBmaWxlIGJ5IEZUUCAoaW50byB0aGUgc2FtZSBkaXJlY3RvcnkgYXMgdGhpcyBpbXBvcnRidWRkeS5waHAgZmlsZSksIHRoZSB1cGxvYWQgdGFiLCBvciBpbXBvcnQgZnJvbSBTdGFzaCB2aWEgdGhlIFN0YXNoIHRhYiBhYm92ZSB0byBjb250aW51ZS4KCQkJPGI+RG8gbm90IHJlbmFtZSB0aGUgYmFja3VwIGZpbGUgZnJvbSBpdHMgb3JpZ2luYWwgZmlsZW5hbWUuPC9iPiBJZiB5b3UgbWFudWFsbHkgZXh0cmFjdGVkL3VuemlwcGVkLCB1cGxvYWQgdGhlIGJhY2t1cCBmaWxlLAoJCQlzZWxlY3QgaXQsIHRoZW4gc2VsZWN0IDxpPkFkdmFuY2VkIFRyb3VibGVzaG9vdGluZyBPcHRpb25zPC9pPiAmIGNsaWNrIDxpPlNraXAgWmlwIEV4dHJhY3Rpb248L2k+LiBSZWZyZXNoIHRoaXMgcGFnZSBvbmNlIHlvdSBoYXZlIHVwbG9hZGVkIHRoZSBiYWNrdXAuJwoJCSk7CgoJfSBlbHNlIHsgLy8gRm91bmQgb25lIG9yIG1vcmUgYmFja3Vwcy4KCQk/PgoJCQk8Zm9ybSBhY3Rpb249Ij9hamF4PTIiIG1ldGhvZD0icG9zdCIgdGFyZ2V0PSJtaW5pRnJhbWUiPgoJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0icGFzc19oYXNoIiB2YWx1ZT0iPD9waHAgZWNobyBQQl9QQVNTV09SRDsgPz4iPgoJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0ib3B0aW9ucyIgdmFsdWU9Ijw/cGhwIGVjaG8gaHRtbHNwZWNpYWxjaGFycyggc2VyaWFsaXplKCBwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnMgKSApOyA/PiciIC8+CgkJPD9waHAKCQllY2hvICc8ZGl2IGNsYXNzPSJiYWNrdXBfc2VsZWN0X3RleHQiPkJhY2t1cHMgaW4gPHNwYW4+JyAuIEFCU1BBVEggLiAnPC9zcGFuPjwvZGl2Pic7CgkJZWNobyAnPHVsIGNsYXNzPSJyb3VuZC13cmFwIj4nOwoJCSRiYWNrdXBfY291bnQgPSBjb3VudCggJGJhY2t1cF9hcmNoaXZlcyApOwoJCSRpICAgICAgICAgICAgPSAwOwoJCWZvcmVhY2ggKCAkYmFja3VwX2FyY2hpdmVzIGFzICRiYWNrdXBfaWQgPT4gJGJhY2t1cF9hcmNoaXZlICkgewoJCQkkaSsrOwoKCgkJCSRiYWNrdXBfdHlwZSAgICAgID0gJyc7CgkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJyc7CgkJCWlmICggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3R5cGUnXSA9PSAnJyApIHsKCQkJCWlmICggc3RyaXN0ciggJGJhY2t1cF9hcmNoaXZlWydmaWxlJ10sICctZGItJyApICE9PSBmYWxzZSApIHsKCQkJCQkkYmFja3VwX3R5cGVfdGV4dCA9ICdEYXRhYmFzZSBPbmx5IEJhY2t1cCc7CgkJCQkJJGJhY2t1cF90eXBlICAgICAgPSAnZGInOwoJCQkJfSBlbHNlaWYgKCBzdHJpc3RyKCAkYmFja3VwX2FyY2hpdmVbJ2ZpbGUnXSwgJy1mdWxsLScgKSAhPT0gZmFsc2UgKSB7CgkJCQkJJGJhY2t1cF90eXBlX3RleHQgPSAnRnVsbCBCYWNrdXAnOwoJCQkJCSRiYWNrdXBfdHlwZSAgICAgID0gJ2Z1bGwnOwoJCQkJfSBlbHNlaWYgKCBzdHJpc3RyKCAkYmFja3VwX2FyY2hpdmVbJ2ZpbGUnXSwgJy1maWxlcy0nICkgIT09IGZhbHNlICkgewoJCQkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJ0ZpbGVzIE9ubHkgQmFja3VwJzsKCQkJCQkkYmFja3VwX3R5cGUgICAgICA9ICdmaWxlcyc7CgkJCQl9IGVsc2VpZiAoIHN0cmlzdHIoICRiYWNrdXBfYXJjaGl2ZVsnZmlsZSddLCAnLWV4cG9ydC0nICkgIT09IGZhbHNlICkgewoJCQkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJ011bHRpc2l0ZSBTdWJzaXRlIEV4cG9ydCc7CgkJCQkJJGJhY2t1cF90eXBlICAgICAgPSAnZXhwb3J0JzsKCQkJCX0KCQkJfSBlbHNlIHsKCQkJCWlmICggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3R5cGUnXSA9PSAnZGInICkgewoJCQkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJ0RhdGFiYXNlIE9ubHkgQmFja3VwJzsKCQkJCQkkYmFja3VwX3R5cGUgICAgICA9ICdkYic7CgkJCQl9IGVsc2VpZiAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWyd0eXBlJ10gPT0gJ2Z1bGwnICkgewoJCQkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJ0Z1bGwgQmFja3VwJzsKCQkJCQkkYmFja3VwX3R5cGUgICAgICA9ICdmdWxsJzsKCQkJCX0gZWxzZWlmICggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3R5cGUnXSA9PSAnZmlsZXMnICkgewoJCQkJCSRiYWNrdXBfdHlwZV90ZXh0ID0gJ0ZpbGVzIE9ubHkgQmFja3VwJzsKCQkJCQkkYmFja3VwX3R5cGUgICAgICA9ICdmaWxlcyc7CgkJCQl9IGVsc2VpZiAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWyd0eXBlJ10gPT0gJ2V4cG9ydCcgKSB7CgkJCQkJJGJhY2t1cF90eXBlX3RleHQgPSAnTXVsdGlzaXRlIFN1YnNpdGUgRXhwb3J0JzsKCQkJCQkkYmFja3VwX3R5cGUgICAgICA9ICdleHBvcnQnOwoJCQkJfSBlbHNlIHsKCQkJCQkkYmFja3VwX3R5cGVfdGV4dCA9ICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWyd0eXBlJ10gLiAnIEJhY2t1cCc7CgkJCQkJJGJhY2t1cF90eXBlICAgICAgPSAkYmFja3VwX2FyY2hpdmVbJ2NvbW1lbnQnXVsndHlwZSddOwoJCQkJfQoJCQl9CgoKCQkJZWNobyAnPGxpPic7CgoJCQllY2hvICc8aW5wdXQgY2xhc3M9InNlbGVjdGFibGVCYWNrdXBBcmNoaXZlIiB0eXBlPSJyYWRpbyIgJzsKCQkJaWYgKCAkYmFja3VwX2lkID09IDAgKSB7CgkJCQllY2hvICdjaGVja2VkPSJjaGVja2VkIiAnOwoJCQl9CgkJCWVjaG8gJ25hbWU9ImZpbGUiIHZhbHVlPSInIC4gZXNjX2F0dHIoICRiYWNrdXBfYXJjaGl2ZVsnZmlsZSddICkgLiAnIiBkYXRhLXR5cGU9IicgLiAkYmFja3VwX3R5cGUgLiAnIj4gJyAuIGVzY19hdHRyKCAkYmFja3VwX2FyY2hpdmVbJ2ZpbGUnXSApOwoJCQllY2hvICc8c3BhbiBzdHlsZT0iZmxvYXQ6IHJpZ2h0OyI+JyAuIHBiX2JhY2t1cGJ1ZGR5OjokZm9ybWF0LT5maWxlX3NpemUoIGZpbGVzaXplKCBBQlNQQVRIIC4gZXNjX2F0dHIoICRiYWNrdXBfYXJjaGl2ZVsnZmlsZSddICkgKSApIC4gJzwvc3Bhbj4nOwoKCQkJZWNobyAnPGRpdiBjbGFzcz0iZGVzY3JpcHRpb24iIHN0eWxlPSJtYXJnaW4tbGVmdDogMjJweDsgbWFyZ2luLXRvcDogNnB4OyBmb250LXN0eWxlOiBub3JtYWw7IGxpbmUtaGVpZ2h0OiAyNnB4OyI+JzsKCQkJJG1ldGEgPSBhcnJheSgpOwoKCQkJZWNobyAkYmFja3VwX3R5cGVfdGV4dDsKCgkJCWlmICggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ2NyZWF0ZWQnXSAhPSAnJyApIHsKCQkJCWVjaG8gJyBmcm9tICcgLiBwYl9iYWNrdXBidWRkeTo6JGZvcm1hdC0+ZGF0ZSggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ2NyZWF0ZWQnXSApOwoJCQl9CgoJCQlpZiAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWyd3cF92ZXJzaW9uJ10gIT0gJycgKSB7CgkJCQllY2hvICcgb24gV29yZFByZXNzIHYnIC4gJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3dwX3ZlcnNpb24nXTsKCQkJfQoKCQkJaWYgKCAkYmFja3VwX2FyY2hpdmVbJ2NvbW1lbnQnXVsnc2l0ZXVybCddICE9ICcnICkgewoJCQkJZWNobyAnPGJyPlNpdGU6ICcgLiAkYmFja3VwX2FyY2hpdmVbJ2NvbW1lbnQnXVsnc2l0ZXVybCddOwoJCQl9CgoJCQlpZiAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWydwcm9maWxlJ10gIT0gJycgKSB7CgkJCQllY2hvICc8YnI+UHJvZmlsZTogJyAuIGh0bWxlbnRpdGllcyggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3Byb2ZpbGUnXSApOwoJCQl9CgoJCQlpZiAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddWydub3RlJ10gIT0gJycgKSB7CgkJCQllY2hvICc8YnI+Tm90ZTogJyAuIGh0bWxlbnRpdGllcyggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ25vdGUnXSApIC4gJzxicj4nOwoJCQl9CgoJCQkvLyBTaG93IG1ldGEgYnV0dG9uIGlmIG1ldGEgaW5mbyBhdmFpbGFibGUuCgkJCWlmICggJGJhY2t1cF9hcmNoaXZlWydjb21tZW50J11bJ3R5cGUnXSAhPSAnJyApIHsKCQkJCSRmaWxlX2hhc2ggPSBtZDUoICRiYWNrdXBfYXJjaGl2ZVsnZmlsZSddICk7CgkJCQllY2hvICc8YSBocmVmPSIjaGFzaF92aWV3IiBjbGFzcz0iYnV0dG9uIGxlYW5Nb2RhbCB2aWV3X2hhc2hfY2xpY2siIHN0eWxlPSIgZmxvYXQ6IHJpZ2h0OyIgaWQ9InZpZXdfaGFzaF8nIC4gJGkgLiAnIiBkYXRhLWZpbGU9IicgLiAkYmFja3VwX2FyY2hpdmVbJ2ZpbGUnXSAuICciPlZpZXcgQ2hlY2tzdW08L2E+JzsKCQkJCWVjaG8gJzxhIGhyZWY9IiNpbmZvXycgLiAkZmlsZV9oYXNoIC4gJyIgY2xhc3M9ImJ1dHRvbiBsZWFuTW9kYWwiIHN0eWxlPSJmbG9hdDogcmlnaHQ7IiBpZD0idmlld19tZXRhXycgLiAkaSAuICciPlZpZXcgTWV0YTwvYT4nOwoJCQkJPz4KCQkJCTxkaXYgaWQ9Imhhc2hfdmlldyIgc3R5bGU9ImRpc3BsYXk6IG5vbmU7Ij4KCQkJCQk8ZGl2IGNsYXNzPSJtb2RhbCI+CgkJCQkJCTxkaXYgY2xhc3M9Im1vZGFsX2hlYWRlciI+CgkJCQkJCQk8aDI+VmlldyBDaGVja3N1bTwvaDI+CgkJCQkJCQk8YSBjbGFzcz0ibW9kYWxfY2xvc2UiPgoJCQkJCQkJCTxzcGFuIGNsYXNzPSJtb2RhbF9jbG9zZV9pY29uIj4mdGltZXM7PC9zcGFuPjxzcGFuPkNsb3NlPC9zcGFuPgoJCQkJCQkJPC9hPgoJCQkJCQk8L2Rpdj4KCQkJCQkJPGRpdiBjbGFzcz0ibW9kYWxfY29udGVudCI+CgkJCQkJCQk8c3BhbiBpZD0iaGFzaF92aWV3X2xvYWRpbmciPjxpbWcgc3JjPSI8P3BocCBlY2hvIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fdXJsKCk7ID8+L2Fzc2V0cy9kaXN0L2ltYWdlcy9sb2FkaW5nLmdpZiI+IENhbGN1bGF0aW5nIGJhY2t1cCBmaWxlIENoZWNrc3VtIChNRDUgaGFzaCkuLi4gVGhpcyBtYXkgdGFrZSBhIG1vbWVudC4uLjwvc3Bhbj4KCQkJCQkJCTxzcGFuIGlkPSJoYXNoX3ZpZXdfcmVzcG9uc2UiPjwvc3Bhbj4KCQkJCQkJPC9kaXY+CgkJCQkJPC9kaXY+CgkJCQk8L2Rpdj4KCQkJCTxkaXYgaWQ9Ijw/cGhwIGVjaG8gJ2luZm9fJyAuICRmaWxlX2hhc2g7ID8+IiBzdHlsZT0iZGlzcGxheTogbm9uZTsgaGVpZ2h0OiA5MCU7Ij4KCQkJCQk8ZGl2IGNsYXNzPSJtb2RhbCI+CgkJCQkJCTxkaXYgY2xhc3M9Im1vZGFsX2hlYWRlciI+CgkJCQkJCQk8aDI+QmFja3VwIE1ldGEgSW5mb3JtYXRpb248L2gyPgoJCQkJCQkJPGEgY2xhc3M9Im1vZGFsX2Nsb3NlIj4KCQkJCQkJCQk8c3BhbiBjbGFzcz0ibW9kYWxfY2xvc2VfaWNvbiI+JnRpbWVzOzwvc3Bhbj48c3Bhbj5DbG9zZTwvc3Bhbj4KCQkJCQkJCTwvYT4KCQkJCQkJPC9kaXY+CgkJCQkJCTxkaXYgY2xhc3M9Im1vZGFsX2NvbnRlbnQiPgoJCQkJCQkJPD9waHAKCQkJCQkJCSRjb21tZW50X21ldGEgPSBhcnJheSgpOwoJCQkJCQkJZm9yZWFjaCAoICRiYWNrdXBfYXJjaGl2ZVsnY29tbWVudCddIGFzICRjb21tZW50X2xpbmVfbmFtZSA9PiAkY29tbWVudF9saW5lX3ZhbHVlICkgeyAvLyBMb29wIHRocm91Z2ggYWxsIG1ldGEgZmllbGRzIGluIHRoZSBjb21tZW50IGFycmF5IHRvIGRpc3BsYXkuCgoJCQkJCQkJCWlmICggZmFsc2UgIT09ICggJHJlc3BvbnNlID0gYmFja3VwYnVkZHlfY29yZTo6cHJldHR5X21ldGFfaW5mbyggJGNvbW1lbnRfbGluZV9uYW1lLCAkY29tbWVudF9saW5lX3ZhbHVlICkgKSApIHsKCQkJCQkJCQkJJGNvbW1lbnRfbWV0YVtdID0gJHJlc3BvbnNlOwoJCQkJCQkJCX0KCQkJCQkJCX0KCQkJCQkJCWlmICggY291bnQoICRjb21tZW50X21ldGEgKSA+IDAgKSB7CgkJCQkJCQkJcGJfYmFja3VwYnVkZHk6OiR1aS0+bGlzdF90YWJsZSgKCQkJCQkJCQkJJGNvbW1lbnRfbWV0YSwKCQkJCQkJCQkJYXJyYXkoCgkJCQkJCQkJCQknY29sdW1ucycgPT4gYXJyYXkoICdNZXRhIEluZm9ybWF0aW9uJywgJ1ZhbHVlJyApLAoJCQkJCQkJCQkJJ2NzcycgICAgID0+ICd3aWR0aDogMTAwJTsgbWluLXdpZHRoOiAyMDBweDsnLAoJCQkJCQkJCQkpCgkJCQkJCQkJKTsKCQkJCQkJCX0gZWxzZSB7CgkJCQkJCQkJZWNobyAnPGk+Tm8gbWV0YSBkYXRhIGZvdW5kIGluIHppcCBjb21tZW50LiBTa2lwcGluZyBtZXRhIGluZm9ybWF0aW9uIGRpc3BsYXkuPC9pPic7CgkJCQkJCQl9CgkJCQkJCQk/PgoJCQkJCQk8L2Rpdj4KCQkJCQk8L2Rpdj4KCQkJCTwvZGl2PgoJCQkJPD9waHAKCQkJfSAvLyBlbmQgaWYgdHlwZSBub3QgYmxhbmsuCgoKCQkJLy8gZWNobyBpbXBsb2RlKCAnIC0gJywgJG1ldGEgKTsKCQkJZWNobyAnPC9kaXY+JzsKCQkJZWNobyAnPC9saT4nOwoJCX0KCQllY2hvICc8L3VsPic7Cgl9Cgk/PgoKPD9waHAKfSAvLyBFbmQgZmlsZSBub3QgZ2l2ZW4gaW4gcXVlcnlzdHJpbmcuCgoKLy8gSWYgb25lIG9yIG1vcmUgYmFja3VwIGZpbGVzIHdhcyBmb3VuZCB0aGVuIHByb3ZpZGUgYSBidXR0b24gdG8gY29udGludWUuCmlmICggKCAhIGVtcHR5KCAkYmFja3VwX2FyY2hpdmVzICkgKSB8fCAoICdzdGFzaCcgPT0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAndXBsb2FkJyApICkgKSB7CgllY2hvICc8L2Rpdj48IS0tIC93cmFwIC0tPic7Cgk/PgoKCTxkaXYgY2xhc3M9Im1haW5fYm94X2Zvb3QiPgoJCTxjZW50ZXI+CgoJCQk8ZGl2IHN0eWxlPSJtYXJnaW4tdG9wOiAyMHB4OyBtYXJnaW4tYm90dG9tOiAzMHB4OyI+CgkJCQk8Yj5XaGF0IHdvdWxkIHlvdSBsaWtlIHRvIHJlc3RvcmUgZnJvbSB0aGUgYmFja3VwPzwvYj4KCQkJCSZuYnNwOyZuYnNwOwoJCQkJPGxhYmVsIHN0eWxlPSJmbG9hdDogaW5oZXJpdDsiPgoJCQkJCTxpbnB1dCB0eXBlPSJjaGVja2JveCIgbmFtZT0icmVzdG9yZUZpbGVzIiB2YWx1ZT0iMSIgQ0hFQ0tFRD4gRmlsZXMKCQkJCTwvbGFiZWw+CgkJCQkmbmJzcDsmbmJzcDsKCQkJCTxsYWJlbCBzdHlsZT0iZmxvYXQ6IGluaGVyaXQ7Ij4KCQkJCQk8aW5wdXQgdHlwZT0iY2hlY2tib3giIG5hbWU9InJlc3RvcmVEYXRhYmFzZSIgdmFsdWU9IjEiIENIRUNLRUQ+IERhdGFiYXNlCgkJCQk8L2xhYmVsPgoJCQk8L2Rpdj4KCgkJCTxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9InN1Ym1pdCIgdmFsdWU9IlJlc3RvcmUgQmFja3VwIiBjbGFzcz0iYnV0dG9uIGJ1dHRvbi1wcmltYXJ5Ij4KCQkJPGJ1dHRvbiBpZD0iYWR2YW5jZWRfb3B0aW9uc19idXR0b24iIGhyZWY9IiNwYl9hZHZhbmNlZF9tb2RhbCIgY2xhc3M9ImJ1dHRvbiBidXR0b24tc2Vjb25kYXJ5IGxlYW5Nb2RhbCI+QWR2YW5jZWQgT3B0aW9uczwvYnV0dG9uPgoJCTwvY2VudGVyPgoJPC9kaXY+Cjw/cGhwCn0gZWxzZSB7CgkvLyBwYl9iYWNrdXBidWRkeTo6YWxlcnQoICdVcGxvYWQgYSBiYWNrdXAgZmlsZSB0byBjb250aW51ZS4nICk7CgllY2hvICc8YnIgLz48YnIgLz48YnIgLz4nOwoJZWNobyAnPGI+WW91IG11c3QgdXBsb2FkIGEgYmFja3VwIGZpbGUgYnkgRlRQLCB0aGUgdXBsb2FkIHRhYiwgb3IgaW1wb3J0IGZyb20gU3Rhc2ggdG8gY29udGludWUuPC9iPic7CgllY2hvICc8L2Rpdj48IS0tIC93cmFwIC0tPic7Cn0KPz4KCgo8ZGl2IGlkPSJwYl9hZHZhbmNlZF9tb2RhbCIgc3R5bGU9ImRpc3BsYXk6IG5vbmU7Ij4KCTxkaXYgY2xhc3M9Im1vZGFsIj4KCQk8ZGl2IGNsYXNzPSJtb2RhbF9oZWFkZXIiPgoJCQk8ZGl2PgoJCQkJPGgyPkFkdmFuY2VkIE9wdGlvbnM8L2gyPgoJCQkJPHA+RXhlcmNpc2UgY2F1dGlvbi4gQWRkaXRpb25hbCBvcHRpb25zIGF2YWlsYWJsZSBvbiBzdWJzZXF1ZW50IHN0ZXBzLjwvcD4KCQkJPC9kaXY+CgkJCTxhIGNsYXNzPSJtb2RhbF9jbG9zZSI+CgkJCQk8c3BhbiBjbGFzcz0ibW9kYWxfY2xvc2VfaWNvbiI+JnRpbWVzOzwvc3Bhbj48c3Bhbj5DbG9zZTwvc3Bhbj4KCQkJPC9hPgoJCTwvZGl2PgoJCTxkaXYgY2xhc3M9Im1vZGFsX2NvbnRlbnQiPgoKCgkJCVVuemlwIFN0cmF0ZWd5OgoJCQk8c2VsZWN0IG5hbWU9InppcE1ldGhvZFN0cmF0ZWd5Ij4KCQkJCTxvcHRpb24gdmFsdWU9ImFsbCIgU0VMRUNURUQ+QWxsIEF2YWlsYWJsZSAoIHVuemlwIHZpYSBleGVjKCkgJmd0OyBaaXBBcmNoaXZlICZndDsgUGNsWmlwICkgLSBkZWZhdWx0PC9vcHRpb24+CgkJCQk8b3B0aW9uIHZhbHVlPSJ6aXBhcmNoaXZlIj5Db21wYXRpYmlsaXR5OiBaaXBBcmNoaXZlPC9vcHRpb24+CgkJCQk8b3B0aW9uIHZhbHVlPSJwY2x6aXAiPkNvbXBhdGliaWxpdHk6IFBjbFppcDwvb3B0aW9uPgoJCQk8L3NlbGVjdD4KCQkJPGJyPjxicj4KCgkJCTw/cGhwCgkJCSRtaWdyYXRlX2h0YWNjZXNzX2lucHV0ID0gJzxpbnB1dCB0eXBlPSJjaGVja2JveCIgbmFtZT0ibWlncmF0ZUh0YWNjZXNzIiB2YWx1ZT0iMSIgQ0hFQ0tFRD4gTWlncmF0ZSAuaHRhY2Nlc3MgZmlsZSBVUkxzICYgcGF0aHMgKGlmIFVSTCBjaGFuZ2VzKS48YnI+JzsKCQkJJG1pZ3JhdGVfaHRhY2Nlc3NfaW5wdXQgPSBpdF9idWJfaW1wb3J0YnVkZHlfYXBwbHlfZmlsdGVycyggJ21pZ3JhdGVfaHRhY2Nlc3NfaW5wdXQnLCAkbWlncmF0ZV9odGFjY2Vzc19pbnB1dCApOwoJCQllY2hvICRtaWdyYXRlX2h0YWNjZXNzX2lucHV0OwoJCQk/PgoJCQk8aW5wdXQgdHlwZT0iY2hlY2tib3giIG5hbWU9InNraXBVbnppcCIgdmFsdWU9IjEiPiBTa2lwIHVuemlwcGluZyBvciBvcGVuaW5nIGFyY2hpdmUgKGZvciBtYW51YWwgZXh0cmFjdGlvbikuCgkJCTxicj48YnI+CgoKCgkJPC9kaXY+Cgk8L2Rpdj4KPC9kaXY+CgoKPD9waHAKZWNobyAnPC9mb3JtPic7Cj8+Cgo8L2Rpdj48IS0tIGVuZCB3cmFwcGVyIGRpdiAtLT4KCgo8ZGl2IGlkPSJwYl91cGxvYWRfbW9kYWwiIHN0eWxlPSJkaXNwbGF5OiBub25lOyI+Cgk8ZGl2IGNsYXNzPSJtb2RhbCI+CgkJPGRpdiBjbGFzcz0ibW9kYWxfaGVhZGVyIj4KCQkJPGRpdj4KCQkJCTxoMj5VcGxvYWQgQmFja3VwPC9oMj4KCQkJCTxwPlNtYWxsZXIgYmFja3VwcyBjYW4gYmUgdXBsb2FkZWQgaGVyZSBkaXJlY3RseSBmcm9tIHlvdXIgY29tcHV0ZXIuIExhcmdlciBiYWNrdXBzIHdvcmsgYmVzdCBvdmVyIEZUUCBvciBvdGhlciBtZXRob2RzLjwvcD4KCQkJPC9kaXY+CgkJCTxhIGNsYXNzPSJtb2RhbF9jbG9zZSI+CgkJCQk8c3BhbiBjbGFzcz0ibW9kYWxfY2xvc2VfaWNvbiI+JnRpbWVzOzwvc3Bhbj48c3Bhbj5DbG9zZTwvc3Bhbj4KCQkJPC9hPgoJCTwvZGl2PgoJCTxkaXYgY2xhc3M9Im1vZGFsX2NvbnRlbnQiPgoKCgkJCTxmb3JtIGVuY3R5cGU9Im11bHRpcGFydC9mb3JtLWRhdGEiIGFjdGlvbj0iIiBtZXRob2Q9IlBPU1QiPgoJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0icGFzc19oYXNoIiB2YWx1ZT0iPD9waHAgZWNobyBQQl9QQVNTV09SRDsgPz4iPgoJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0idXBsb2FkIiB2YWx1ZT0ibG9jYWwiPgoJCQkJPGlucHV0IHR5cGU9ImhpZGRlbiIgbmFtZT0ib3B0aW9ucyIgdmFsdWU9Ijw/cGhwIGVjaG8gaHRtbHNwZWNpYWxjaGFycyggc2VyaWFsaXplKCBwYl9iYWNrdXBidWRkeTo6JG9wdGlvbnMgKSApOyA/PiciPgoJCQkJQ2hvb3NlIGEgbG9jYWwgYmFja3VwIHRvIHVwbG9hZDo8YnI+CgkJCQk8cD4KCQkJCQk8aW5wdXQgbmFtZT0iZmlsZSIgdHlwZT0iZmlsZSIgc3R5bGU9IndpZHRoOiAxMDAlOyI+CgkJCQk8L3A+CgkJCQk8YnI+CgkJCQk8aW5wdXQgdHlwZT0ic3VibWl0IiB2YWx1ZT0iVXBsb2FkIEJhY2t1cCIgY2xhc3M9InRvZ2dsZSBidXR0b24iPgoJCQk8L2Zvcm0+CgoKCQk8L2Rpdj4KCTwvZGl2Pgo8L2Rpdj4KCgo8ZGl2IGlkPSJwYl9zdGFzaF9tb2RhbCIgc3R5bGU9ImRpc3BsYXk6IG5vbmU7Ij4KCTxkaXYgY2xhc3M9Im1vZGFsIj4KCQk8ZGl2IGNsYXNzPSJtb2RhbF9oZWFkZXIiPgoJCQk8ZGl2PgoJCQkJPGgyPlJlc3RvcmUgQmFja3VwIGZyb20gU3Rhc2g8L2gyPgoJCQkJPHA+QmFja3VwcyBzdG9yZWQgaW4geW91ciBTb2xpZCBTdGFzaCBtYXkgYmUgcmV0cmlldmVkIGZvciByZXN0b3JpbmcgaGVyZS48L3A+CgkJCTwvZGl2PgoJCQk8YSBjbGFzcz0ibW9kYWxfY2xvc2UiPgoJCQkJPHNwYW4gY2xhc3M9Im1vZGFsX2Nsb3NlX2ljb24iPiZ0aW1lczs8L3NwYW4+PHNwYW4+Q2xvc2U8L3NwYW4+CgkJCTwvYT4KCQk8L2Rpdj4KCQk8ZGl2IGNsYXNzPSJtb2RhbF9jb250ZW50Ij4KCgkJCTw/cGhwIHJlcXVpcmUgJ19odG1sXzFfc3Rhc2gucGhwJzsgPz4KCgkJPC9kaXY+Cgk8L2Rpdj4KPC9kaXY+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/home.php,importbuddy/views/home.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
PGNlbnRlcj4KCTxoMz5SZXN0b3JpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0iaW1wb3J0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/importingDatabase.htm,importbuddy/views/importingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
PHNjcmlwdD4KCWpRdWVyeSggJyNwYWdlVGl0bGUnICkuYWRkQ2xhc3MoJ2xvZ2luLXNjcmVlbicpLmh0bWwoICdXZWxjb21lLCBwbGVhc2UgbG9nIGluIHRvIGNvbnRpbnVlLicgKTsKCWpRdWVyeSgnLm1haW5fYm94X3dyYXAnKS5hZGRDbGFzcygnbWFpbl9ib3hfd3JhcC0tc21hbGwnKTsKPC9zY3JpcHQ+Cjw/cGhwCgoKaWYgKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdwYXNzd29yZCcgKSAhPSAnJyApIHsKCWdsb2JhbCAkcGJfbG9naW5fYXR0ZW1wdHM7CglwYl9iYWNrdXBidWRkeTo6YWxlcnQoICdJbnZhbGlkIHBhc3N3b3JkLiBQbGVhc2UgZW50ZXIgdGhlIHBhc3N3b3JkIHlvdSBwcm92aWRlZCB3aXRoaW4gU29saWQgQmFja3VwcyBTZXR0aW5ncy4gQXR0ZW1wdCAjJyAuICRwYl9sb2dpbl9hdHRlbXB0cyAuICcuJyApOwoJZWNobyAnPGJyPic7Cn0KPz4KCjxwPkVudGVyIHlvdXIgSW1wb3J0ZXIgcGFzc3dvcmQgYmVsb3cgdG8gYmVnaW4uPC9wPgoKPGZvcm0gbWV0aG9kPSJwb3N0Ij4KCTxpbnB1dCB0eXBlPSJoaWRkZW4iIG5hbWU9ImFjdGlvbiIgdmFsdWU9ImxvZ2luIj4KCTxpbnB1dCB0eXBlPSJwYXNzd29yZCIgbmFtZT0icGFzc3dvcmQiIHN0eWxlPSJ3aWR0aDogMjUwcHg7Ij4KCTxpbnB1dCB0eXBlPSJzdWJtaXQiIG5hbWU9InN1Ym1pdCIgdmFsdWU9IkF1dGhlbnRpY2F0ZSIgY2xhc3M9Iml0LWJ1dHRvbiI+CjwvZm9ybT4K
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/login.php,importbuddy/views/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
PGNlbnRlcj4KCTxoMz5NaWdyYXRpbmcgRGF0YWJhc2UgLi4uPC9oMz4KCTxoNCBpZD0ibWlncmF0aW5nRGF0YWJhc2UtcHJvZ3Jlc3NNZXNzYWdlIj48L2g0Pgo8L2NlbnRlcj4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/migratingDatabase.htm,importbuddy/views/migratingDatabase.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
PGNlbnRlcj4KCTxoMz5QbGVhc2Ugd2FpdCB3aGlsZSB5b3VyIGZpbGVzIGFyZSByZXN0b3JlZCAuLi48L2gzPgoJPGg0IGlkPSJ1bnppcHBpbmdGaWxlcy1wcm9ncmVzc01lc3NhZ2UiPlJlc3RvcmluZyBGaWxlczwvaDQ+CjwvY2VudGVyPg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/unzippingFiles.htm,importbuddy/views/unzippingFiles.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/views/urlReplaceSettings.htm,importbuddy/views/urlReplaceSettings.htm
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/2.php,importbuddy/controllers/ajax/2.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/4.php,importbuddy/controllers/ajax/4.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/5.php,importbuddy/controllers/ajax/5.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/6.php,importbuddy/controllers/ajax/6.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgpBdXRoOjpyZXF1aXJlX2F1dGhlbnRpY2F0aW9uKCk7IC8vIERpZSBpZiBub3QgbG9nZ2VkIGluLgoKLy9wcmludF9yKCBwYl9iYWNrdXBidWRkeTo6X1BPU1QoKSApOwoKJGNwYW5lbF91c2VyID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VzZXInICk7CiRjcGFuZWxfcGFzc3dvcmQgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcGFzcycgKTsKJGNwYW5lbF9ob3N0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3VybCcgKTsKJGNwYW5lbF9wb3J0ID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX3BvcnQnICk7CiRjcGFuZWxfcHJvdG9jb2wgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfcHJvdG9jb2wnICk7CiRkYl9uYW1lID0gcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnY3BhbmVsX2RibmFtZScgKTsKJGRiX3VzZXIgPSBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdjcGFuZWxfZGJ1c2VyJyApOwokZGJfcGFzcyA9IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ2NwYW5lbF9kYnBhc3MnICk7CgovLyBOZWVkZWQgZm9yIEhUVFAgcmVxdWVzdHMuCiRyZXF1ZXN0Y29yZV9maWxlID0gcGJfYmFja3VwYnVkZHk6OnBsdWdpbl9wYXRoKCkgLiAnL2xpYi9yZXF1ZXN0Y29yZS9yZXF1ZXN0Y29yZS5jbGFzcy5waHAnOwpyZXF1aXJlX29uY2UoICRyZXF1ZXN0Y29yZV9maWxlICk7CgpyZXF1aXJlX29uY2UoIHBiX2JhY2t1cGJ1ZGR5OjpwbHVnaW5fcGF0aCgpIC4gJy9saWIvY3BhbmVsL2NwYW5lbC5waHAnICk7CiRjcmVhdGVfZGJfcmVzdWx0ID0gcGJfYmFja3VwYnVkZHlfY3BhbmVsOjpjcmVhdGVfZGIoICRjcGFuZWxfdXNlciwgJGNwYW5lbF9wYXNzd29yZCwgJGNwYW5lbF9ob3N0LCAkZGJfbmFtZSwgJGRiX3VzZXIsICRkYl9wYXNzLCAkY3BhbmVsX3BvcnQsICRjcGFuZWxfcHJvdG9jb2wgKTsKCmlmICggJGNyZWF0ZV9kYl9yZXN1bHQgPT09IHRydWUgKSB7CgllY2hvICdTdWNjZXNzISBDcmVhdGVkIGRhdGFiYXNlLCB1c2VyLCBhbmQgYXNzaWduZWQgdXNlciB0byBkYXRhYmFzZS4nOwp9IGVsc2UgewoJZWNobyAiVW5hYmxlIHRvIGF1dG9tYXRpY2FsbHkgY3JlYXRlIGRhdGFiYXNlIHdpdGggdGhlIHByb3ZpZGVkIHNldHRpbmdzLiBDaGVjayBzZXR0aW5ncyBvciBtYW51YWxseSBjcmVhdGUgdGhlIGRhdGFiYXNlIGZyb20geW91ciBob3N0J3MgY29udHJvbCBwYW5lbC4gU2VlIHR1dG9yaWFsIGF0OiAiOwoJZWNobyAiaHR0cHM6Ly9nby5zb2xpZHdwLmNvbS9iYWNrdXBzLXR1dG9yaWFsc1xuXG4iOwoJZWNobyAiRXJyb3IgZGV0YWlsczpcbiIgLiBpbXBsb2RlKCAiXG4iLCAkY3JlYXRlX2RiX3Jlc3VsdCk7Cn0KCmRpZSgpOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/cpanel_createdb.php,importbuddy/controllers/ajax/cpanel_createdb.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgokZmlsZSA9IEFCU1BBVEggLiBwYl9iYWNrdXBidWRkeTo6X1BPU1QoICdmaWxlJyApOwoKaWYgKCAnJyA9PSAkZmlsZSApIHsKCWRpZSggJ05vIGZpbGUgcGFzc2VkLicgKTsKfQppZiAoICEgZmlsZV9leGlzdHMoICRmaWxlICkgKSB7CglkaWUoICdGaWxlIG5vdCBmb3VuZC4nICk7Cn0KCiRmaWxlSGFzaCA9IEBtZDVfZmlsZSggJGZpbGUgKTsKCmlmICggZmFsc2UgPT09ICRmaWxlSGFzaCApIHsKCWRpZSggJ1VuYWJsZSB0byBjYWxjdWxhdGUgaGFzaC4gVmVyaWZ5IGZpbGUgcGVybWlzc2lvbnMuJyApOwp9IGVsc2UgewoJZGllKCBqc29uX2VuY29kZSggYXJyYXkoICdoYXNoJyA9PiAkZmlsZUhhc2ggKSApICk7Cn0=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/file_hash.php,importbuddy/controllers/ajax/file_hash.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoICd0cnVlJyAhPSBwYl9iYWNrdXBidWRkeTo6X0dFVCggJ2RlcGxveScgKSApIHsKCWRpZSggJ0FjY2VzcyBkZW5pZWQuJyApOwp9CgovLyBPbmx5IGFsbG93IGFjY2VzcyB0byB0aGlzIGZpbGUgaWYgaXQgaGFzIGEgc2VyaWFsIGhpZGluZyBpdC4gVXNlZCBieSBkZXBsb3ltZW50LgpnbG9iYWwgJGltcG9ydGJ1ZGR5X2ZpbGU7CiRpbXBvcnRGaWxlU2VyaWFsID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0X3NlcmlhbF9mcm9tX2ZpbGUoICRpbXBvcnRidWRkeV9maWxlICk7CmlmICggJycgPT0gJGltcG9ydEZpbGVTZXJpYWwgKSB7CglkaWUoICdBY2Nlc3MgZGVuaWVkLicgKTsKfQoKcGJfYmFja3VwYnVkZHk6OnN0YXR1cyggJ2RldGFpbHMnLCAnKioqIEVuZCBJbXBvcnRlciBMb2cgU2VjdGlvbiAoRGVwbG95bWVudCknICk7CgovLyBMb2cgdG8gbWFrZSBhIGNvcHkgb2YgcmV0cmlldmVkIGRlcGxveSBpbmZvIGludG8uCiRsb2dfZGlyZWN0b3J5ID0gYmFja3VwYnVkZHlfY29yZTo6Z2V0TG9nRGlyZWN0b3J5KCk7CiRiYWNrdXBfbG9nX2ZpbGUgPSAkbG9nX2RpcmVjdG9yeSAuICdzdGF0dXMtZGVwbG95Y29weS0nIC4gJGltcG9ydEZpbGVTZXJpYWwgLiAnLnR4dCc7Cgokc3RhdHVzX2xpbmVzID0gcGJfYmFja3VwYnVkZHk6OmdldF9zdGF0dXMoICcnLCB0cnVlLCBmYWxzZSwgdHJ1ZSwgJGJhY2t1cF9sb2dfZmlsZSApOyAvLyBDbGVhciBmaWxlLCBkb250IHVubGluayBmaWxlLCBzdXByZXNzIHN0YXR1cyByZXRyaWV2YWwgbXNnLCBiYWNrdXAgaW50byAkbG9nX2ZpbGUKZWNobyBpbXBsb2RlKCAnJywgJHN0YXR1c19saW5lcyApOwo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/getDeployLog.php,importbuddy/controllers/ajax/getDeployLog.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/hash_forgotpass.php,importbuddy/controllers/ajax/hash_forgotpass.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CgppZiAoICcnID09IHBiX2JhY2t1cGJ1ZGR5OjpfUE9TVCggJ25ld3Bhc3N3b3JkJyApICkgewoJZGllKCAnRXJyb3IgIzg0OTM0ODk6IE1pc3NpbmcgcGFzc3dvcmQuJyApOwp9CgpkaWUoIG1kNSggcGJfYmFja3VwYnVkZHk6Ol9QT1NUKCAnbmV3cGFzc3dvcmQnICkgKSApOw==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/hash_forgotpass.php,importbuddy/controllers/ajax/hash_forgotpass.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgovLyBJbmNsdWRlIHRoZSBEQiBUZXN0cyBjbGFzcyBhbmQgaW5pdCBpdC4KcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4gJ2ltcG9ydGJ1ZGR5L2NsYXNzZXMvdGVzdC1kYi5waHAnICk7CiRpbXBvcnRidWRkeV90ZXN0X2RiID0gbmV3IGltcG9ydGJ1ZGR5X3Rlc3RfZGIoKTsK
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/ajax/mysql_test.php,importbuddy/controllers/ajax/mysql_test.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/create_admin.php,importbuddy/controllers/pages/create_admin.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgoKJGRhdGEgPSBhcnJheSgpOwpwYl9iYWNrdXBidWRkeTo6bG9hZF92aWV3KCAnZGJyZXBsYWNlJywgJGRhdGEgKTsKPz48c2NyaXB0PmpRdWVyeSggJyNwYWdlVGl0bGUnICkuaHRtbCggJ0RhdGFiYXNlIFRleHQgUmVwbGFjZScgKTs8L3NjcmlwdD4=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/dbreplace.php,importbuddy/controllers/pages/dbreplace.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/default.php,importbuddy/controllers/pages/default.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/diagnostics.php,importbuddy/controllers/pages/diagnostics.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/diagnostics.php,importbuddy/controllers/pages/diagnostics.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/homeBackupSelect.php,importbuddy/controllers/pages/homeBackupSelect.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/login.php,importbuddy/controllers/pages/login.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
PD9waHAKaWYgKCAhIGRlZmluZWQoICdQQl9JTVBPUlRCVUREWScgKSB8fCAoIHRydWUgIT09IFBCX0lNUE9SVEJVRERZICkgKSB7CglkaWUoICc8aHRtbD48L2h0bWw+JyApOwp9CkF1dGg6OnJlcXVpcmVfYXV0aGVudGljYXRpb24oKTsgLy8gRGllIGlmIG5vdCBsb2dnZWQgaW4uCgpyZXF1aXJlX29uY2UoIEFCU1BBVEggLidpbXBvcnRidWRkeS92aWV3cy9faGVhZGVyLnBocCcgKTsKPz4KPHNjcmlwdD5qUXVlcnkoICcjcGFnZVRpdGxlJyApLmh0bWwoICdTZXJ2ZXIgSW5mb3JtYXRpb24nICk7PC9zY3JpcHQ+Cgo8ZGl2IGNsYXNzPSJ3cmFwIj4KCTw/cGhwCglnbG9iYWwgJGRldGVjdGVkX21heF9leGVjdXRpb25fdGltZTsKCXJlcXVpcmVfb25jZSggJ2RpYWdub3N0aWNzLnBocCcgKTsKCT8+CjwvZGl2PgoKPD9waHAKcmVxdWlyZV9vbmNlKCBBQlNQQVRIIC4naW1wb3J0YnVkZHkvdmlld3MvX2Zvb3Rlci5waHAnICk7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/controllers/pages/serverinfo.php,importbuddy/controllers/pages/serverinfo.php
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/css/importbuddy.css,importbuddy/assets/dist/css/importbuddy.css
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/css/importbuddy.css,importbuddy/assets/dist/css/importbuddy.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/css/pluginbuddy.css,importbuddy/assets/dist/css/pluginbuddy.css
Lm1pbmlDb2xvcnMtdHJpZ2dlcntkaXNwbGF5OmlubGluZS1ibG9jaztoZWlnaHQ6MjJweDttYXJnaW46MCAuMjVlbTtvdXRsaW5lOm5vbmU7dmVydGljYWwtYWxpZ246bWlkZGxlO3dpZHRoOjIycHh9Lm1pbmlDb2xvcnMtc2VsZWN0b3J7YmFja2dyb3VuZDojZmZmO2JvcmRlcjoxcHggc29saWQgI2JiYjtib3JkZXItcmFkaXVzOjVweDtib3gtc2hhZG93OjAgMCA2cHggcmdiYSgwLDAsMCwuMjUpO2hlaWdodDoxNTBweDtwYWRkaW5nOjVweDtwb3NpdGlvbjphYnNvbHV0ZTt3aWR0aDoxNzVweDt6LWluZGV4Ojk5OTk5OX0ubWluaUNvbG9ycy1zZWxlY3Rvci5ibGFja3tiYWNrZ3JvdW5kOiMwMDA7Ym9yZGVyLWNvbG9yOiMwMDB9Lm1pbmlDb2xvcnMtY29sb3Jze2xlZnQ6NXB4O3dpZHRoOjE1MHB4fS5taW5pQ29sb3JzLWNvbG9ycywubWluaUNvbG9ycy1odWVze2N1cnNvcjpjcm9zc2hhaXI7aGVpZ2h0OjE1MHB4O3Bvc2l0aW9uOmFic29sdXRlO3RvcDo1cHh9Lm1pbmlDb2xvcnMtaHVlc3tsZWZ0OjE2MHB4O3dpZHRoOjIwcHh9Lm1pbmlDb2xvcnMtY29sb3JQaWNrZXJ7aGVpZ2h0OjExcHg7cG9zaXRpb246YWJzb2x1dGU7d2lkdGg6MTFweH0ubWluaUNvbG9ycy1odWVQaWNrZXJ7aGVpZ2h0OjNweDtsZWZ0Oi0zcHg7cG9zaXRpb246YWJzb2x1dGU7d2lkdGg6MjZweH0KLnVpLXdpZGdldHtsaW5lLWhlaWdodDoxLjZlbTtwYWRkaW5nOjEwcHh9LnVpLXdpZGdldCAudWktd2lkZ2V0e2ZvbnQtc2l6ZToxZW19LnVpLXdpZGdldC1jb250ZW50e2JhY2tncm91bmQ6I2ZmZjtib3JkZXI6MXB4IHNvbGlkICNhYWE7Y29sb3I6IzIyMn0KCg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/css/pluginbuddy.css,importbuddy/assets/dist/css/pluginbuddy.css
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/icons/close.svg,importbuddy/assets/dist/icons/close.svg
PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCIgd2lkdGg9IjQ4IiBoZWlnaHQ9IjQ4IiBhcmlhLWhpZGRlbj0idHJ1ZSIgZm9jdXNhYmxlPSJmYWxzZSI+PHBhdGggZD0iTTEzIDExLjhsNi4xLTYuMy0xLTEtNi4xIDYuMi02LjEtNi4yLTEgMSA2LjEgNi4zLTYuNSA2LjcgMSAxIDYuNS02LjYgNi41IDYuNiAxLTF6Ij48L3BhdGg+PC9zdmc+Cg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/icons/close.svg,importbuddy/assets/dist/icons/close.svg
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/icons/help.svg,importbuddy/assets/dist/icons/help.svg
PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCIgd2lkdGg9IjQ4IiBoZWlnaHQ9IjQ4IiBhcmlhLWhpZGRlbj0idHJ1ZSIgZm9jdXNhYmxlPSJmYWxzZSI+PHBhdGggZD0iTTEyIDQuNzVhNy4yNSA3LjI1IDAgMTAwIDE0LjUgNy4yNSA3LjI1IDAgMDAwLTE0LjV6TTMuMjUgMTJhOC43NSA4Ljc1IDAgMTExNy41IDAgOC43NSA4Ljc1IDAgMDEtMTcuNSAwek0xMiA4Ljc1YTEuNSAxLjUgMCAwMS4xNjcgMi45OWMtLjQ2NS4wNTItLjkxNy40NC0uOTE3IDEuMDFWMTRoMS41di0uODQ1QTMgMyAwIDEwOSAxMC4yNWgxLjVhMS41IDEuNSAwIDAxMS41LTEuNXpNMTEuMjUgMTV2MS41aDEuNVYxNWgtMS41eiI+PC9wYXRoPjwvc3ZnPgo=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/icons/help.svg,importbuddy/assets/dist/icons/help.svg
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/bullet_go.png,importbuddy/assets/dist/images/bullet_go.png
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAEsSURBVDjLY/j//z8DJZhhmBuQvdj8a+p8w//xc3U5yTIgeb7h18bNUf/DZ2j8958qz0nQgPyltv9zF5v/TV9o/Ddxrv7fmvWh/1ednvi/ZLX/f9d+8b+23YI8eA0AOvn/hnPT/q89OwWsccXpCf8n7Cn5v/B41/+MpW7/TdvZ/+o2M/LjNADoZLDmvl35/zt3ZP9v3Zb2v2Fz4v+mren/Zxxq/h+zwOa/aj3DH5wGRM/W/L/y1IT/S0/0/l94rOv/vKMdQEOy/k8/1PQ/banHf8VahlfSlQwGOA0InK74z3Oi9D/nftF/1t38/+LmW/2fdrDhf9Jit//ytQzPJSsZtEiKBe1mxq/xC53/y1czPAFqVic5GoFO/ipXzfxftJJBkeyUKFzOwDm48wIAh5XH+g7drOwAAAAASUVORK5CYII=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/bullet_go.png,importbuddy/assets/dist/images/bullet_go.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/collapsed.gif,importbuddy/assets/dist/images/collapsed.gif
R0lGODlhBgAHALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAGAAcAAAQVEAFFVUrD0HvF4RfCEYGVFAeFaFUEADs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/collapsed.gif,importbuddy/assets/dist/images/collapsed.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/expanded.gif,importbuddy/assets/dist/images/expanded.gif
R0lGODlhBwAGALMKAM7Ozr6+vq6urp6enoWFhaampt7e3u/v742NjX19ff///wAAAAAAAAAAAAAAAAAAACH5BAEAAAoALAAAAAAHAAYAAAQWEKU5kaETqEKHUgcxGZ8SJEL5IccXAQA7
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/expanded.gif,importbuddy/assets/dist/images/expanded.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/favicon.png,importbuddy/assets/dist/images/favicon.png
iVBORw0KGgoAAAANSUhEUgAAACcAAAAoCAYAAAB99ePgAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAATuSURBVHgBxVhNT1xlFH7eO2Q+KM4gBGjLNBnSkjTFVNxYPjSd2ahxU5pY3ZhYalDqBhp/ALBzYzp1I6bW2sSNqZW60eiGMYq0GzsV202rTAJFaAOZos4M07n37TnvMJSPuR8DA32S+33uvc895zznPfcVKAN6d4+Hlnd5m/B6vclo4oUktgiBEtEfulGdyaS6YOAo3R1eJrQBEjIpoMUNGN9pwnV1eLY9gRLhmBx7R0jZRy87KSCqUTJEDEJeGp7t/NLxHXYG7KmldHqAPNGP8iABoUWceFKzukjeCmfSqRtlJMYIQRqTvfXjA3aGpp57v+G3PgEZxTaC0uOqx7fUHU1EksWvF0Fv/dgAXRnEDoAIxD2+bKQYwQ1hZY/tFDGGBFozac9IsWtrPKfqFeUDngIkRPSzuY4zq8+t9Zw0RvGUQPndzwJcfa6isKPyzKSgFkNjSyUaD1Wh0u+Cz1+B2n0edT79UEdqMYf56SUsTGcwcyuljh1BGhdp3fSEMFbCOWpFrpIIvHiiDodfrUXwUKUi5BTTt1O4O/4QsS9mMD+1ZG0s0F0o1Mvkxk5S0C+a2R9o9+O98wdLImSG2IUZXBlKWJkkhuc6lffyOSdhWhCZUN/Xz5WFGCP87l5a9liZhAq5p31QN9YKm1zj3Ckn0ou6tYE0unij5TQZtn5QDufevIXrl+9jq1ggkXzy1p9OnnWMV+J0w9gIFcIuM6uaoAevn9mHH6JTkGTY3B7AkRP1jkSRVqrNKjH88dM87pFyj1JI+Xzswj+W93p92Wfp6TJk15wwGV7uXFtUX31l6G/1onwJcW8gyS/n0LEyWeX7SVCHX6lFz7Kovj87BTtkH+0KVRgQIadNXXObXy0FcIlgIsVykmtgbfAJcV3X4XK54BSG/qi1gohtonHMg0Obh9/SjolNTNxEY2MQdXX1cArNzoDDk3Za4U3AHmtq2o+amlp1zMJwRI5yPGlNLoePXru55XISCASQ/V/i26FJR8o3NJHksDI509CyWlkMAx2/k1L9OPJGPY2rVatCag3+OBbSHVLs9csP1JjMz7MjqBl5cnFpU4S5lLSxWukF1765jxkafugeBFvy5aRYSWFPc/hYsUyouS2Ans8PKkE5UavXm4lX6JA/axBddsYFD/LCYKUqAvTy9V0Hlw/28nrFOgV9eJw74wpNyDikfTHhyl4T9OLtjw+oYw6r09AyJif/UkqtqnrG1lYIxHmrDc++HLMSRUGt4VN7ETm1B5uF2+1RC8Nerdoltc4zNc7BlFwOX314V+VXY8subBZc49xutxq2rMUgEvRPG1N7vOqvHq1Oe9yTdgW5kHObaTYnfpxXYlootdlk9O7+ZRBSs/3RLYA9yTnIQmGiLAJfwLXS6XLo7t3+j46zJRRx8tpcx0qbvvL53kwumvF43sk3AvaYpoGfl7JC6N2rD1eGr2gyktQNedxuxNg2CAyxONeeWofTDb/20z/kWewkhIgNz3ZE1p/eMPB/OvdSFMIYwg6B5kviXq/vePFrJtgRD5LHmJjZLKjl0NBDPz8uTYw4FUlpxDjHOgetTCz7ufMPOuP0dZQL5kW6dFI8w2lE7IgpUzhEflJaH5RSHNtU98ykoG9QZFnIFaCmYVP/hqWmdQkpnucprGJ2yyWJxm3qerZ7wtoK7FVdN5Q3XS4tWa6p/se57g8A4Kas4AAAAABJRU5ErkJggg==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/favicon.png,importbuddy/assets/dist/images/favicon.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/gray-grad.png,importbuddy/assets/dist/images/gray-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAfCAIAAACgQJBPAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAsSAAALEgHS3X78AAAAIXRFWHRTb2Z0d2FyZQBNYWNyb21lZGlhIEZpcmV3b3JrcyA0LjDqJid1AAAAFnRFWHRDcmVhdGlvbiBUaW1lADEwLzI0LzA4KQ6r+wAAAClJREFUeJxjfPv2LQMSYPn//z8yn4kBFaDzqa0eXZ5U9QMtT6l5tFYPADsXLPcJwrwLAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/gray-grad.png,importbuddy/assets/dist/images/gray-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/icon_16x16.png,importbuddy/assets/dist/images/icon_16x16.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/icon_16x16.png,importbuddy/assets/dist/images/icon_16x16.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/icon_32x32.png,importbuddy/assets/dist/images/icon_32x32.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/icon_32x32.png,importbuddy/assets/dist/images/icon_32x32.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/icon_menu_32x32.png,importbuddy/assets/dist/images/icon_menu_32x32.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/icon_menu_32x32.png,importbuddy/assets/dist/images/icon_menu_32x32.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/loading.gif,importbuddy/assets/dist/images/loading.gif
R0lGODlhEAAQAPQAAObm5iV9ptvf4oy1x87Y3VmZt4GuxCV9pmeguz+LrqbD0LXL1TSFqpu9zSd+pk2SsnOnwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAEAAQAAAFdyAgAgIJIeWoAkRCCMdBkKtIHIngyMKsErPBYbADpkSCwhDmQCBethRB6Vj4kFCkQPG4IlWDgrNRIwnO4UKBXDufzQvDMaoSDBgFb886MiQadgNABAokfCwzBA8LCg0Egl8jAggGAA1kBIA1BAYzlyILczULC2UhACH5BAkKAAAALAAAAAAQABAAAAV2ICACAmlAZTmOREEIyUEQjLKKxPHADhEvqxlgcGgkGI1DYSVAIAWMx+lwSKkICJ0QsHi9RgKBwnVTiRQQgwF4I4UFDQQEwi6/3YSGWRRmjhEETAJfIgMFCnAKM0KDV4EEEAQLiF18TAYNXDaSe3x6mjidN1s3IQAh+QQJCgAAACwAAAAAEAAQAAAFeCAgAgLZDGU5jgRECEUiCI+yioSDwDJyLKsXoHFQxBSHAoAAFBhqtMJg8DgQBgfrEsJAEAg4YhZIEiwgKtHiMBgtpg3wbUZXGO7kOb1MUKRFMysCChAoggJCIg0GC2aNe4gqQldfL4l/Ag1AXySJgn5LcoE3QXI3IQAh+QQJCgAAACwAAAAAEAAQAAAFdiAgAgLZNGU5joQhCEjxIssqEo8bC9BRjy9Ag7GILQ4QEoE0gBAEBcOpcBA0DoxSK/e8LRIHn+i1cK0IyKdg0VAoljYIg+GgnRrwVS/8IAkICyosBIQpBAMoKy9dImxPhS+GKkFrkX+TigtLlIyKXUF+NjagNiEAIfkECQoAAAAsAAAAABAAEAAABWwgIAICaRhlOY4EIgjH8R7LKhKHGwsMvb4AAy3WODBIBBKCsYA9TjuhDNDKEVSERezQEL0WrhXucRUQGuik7bFlngzqVW9LMl9XWvLdjFaJtDFqZ1cEZUB0dUgvL3dgP4WJZn4jkomWNpSTIyEAIfkECQoAAAAsAAAAABAAEAAABX4gIAICuSxlOY6CIgiD8RrEKgqGOwxwUrMlAoSwIzAGpJpgoSDAGifDY5kopBYDlEpAQBwevxfBtRIUGi8xwWkDNBCIwmC9Vq0aiQQDQuK+VgQPDXV9hCJjBwcFYU5pLwwHXQcMKSmNLQcIAExlbH8JBwttaX0ABAcNbWVbKyEAIfkECQoAAAAsAAAAABAAEAAABXkgIAICSRBlOY7CIghN8zbEKsKoIjdFzZaEgUBHKChMJtRwcWpAWoWnifm6ESAMhO8lQK0EEAV3rFopIBCEcGwDKAqPh4HUrY4ICHH1dSoTFgcHUiZjBhAJB2AHDykpKAwHAwdzf19KkASIPl9cDgcnDkdtNwiMJCshACH5BAkKAAAALAAAAAAQABAAAAV3ICACAkkQZTmOAiosiyAoxCq+KPxCNVsSMRgBsiClWrLTSWFoIQZHl6pleBh6suxKMIhlvzbAwkBWfFWrBQTxNLq2RG2yhSUkDs2b63AYDAoJXAcFRwADeAkJDX0AQCsEfAQMDAIPBz0rCgcxky0JRWE1AmwpKyEAIfkECQoAAAAsAAAAABAAEAAABXkgIAICKZzkqJ4nQZxLqZKv4NqNLKK2/Q4Ek4lFXChsg5ypJjs1II3gEDUSRInEGYAw6B6zM4JhrDAtEosVkLUtHA7RHaHAGJQEjsODcEg0FBAFVgkQJQ1pAwcDDw8KcFtSInwJAowCCA6RIwqZAgkPNgVpWndjdyohACH5BAkKAAAALAAAAAAQABAAAAV5ICACAimc5KieLEuUKvm2xAKLqDCfC2GaO9eL0LABWTiBYmA06W6kHgvCqEJiAIJiu3gcvgUsscHUERm+kaCxyxa+zRPk0SgJEgfIvbAdIAQLCAYlCj4DBw0IBQsMCjIqBAcPAooCBg9pKgsJLwUFOhCZKyQDA3YqIQAh+QQJCgAAACwAAAAAEAAQAAAFdSAgAgIpnOSonmxbqiThCrJKEHFbo8JxDDOZYFFb+A41E4H4OhkOipXwBElYITDAckFEOBgMQ3arkMkUBdxIUGZpEb7kaQBRlASPg0FQQHAbEEMGDSVEAA1QBhAED1E0NgwFAooCDWljaQIQCE5qMHcNhCkjIQAh+QQJCgAAACwAAAAAEAAQAAAFeSAgAgIpnOSoLgxxvqgKLEcCC65KEAByKK8cSpA4DAiHQ/DkKhGKh4ZCtCyZGo6F6iYYPAqFgYy02xkSaLEMV34tELyRYNEsCQyHlvWkGCzsPgMCEAY7Cg04Uk48LAsDhRA8MVQPEF0GAgqYYwSRlycNcWskCkApIyEAOwAAAAAAAAAAAA==
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/loading.gif,importbuddy/assets/dist/images/loading.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/loading_large.gif,importbuddy/assets/dist/images/loading_large.gif
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/loading_large.gif,importbuddy/assets/dist/images/loading_large.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/solid-backups-logo.png,importbuddy/assets/dist/images/solid-backups-logo.png
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/solid-backups-logo.png,importbuddy/assets/dist/images/solid-backups-logo.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/solid-backups-logo.svg,importbuddy/assets/dist/images/solid-backups-logo.svg
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
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/solid-backups-logo.svg,importbuddy/assets/dist/images/solid-backups-logo.svg
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/sort_down.png,importbuddy/assets/dist/images/sort_down.png
iVBORw0KGgoAAAANSUhEUgAAAAoAAAAICAYAAADA+m62AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAHBJREFUeNqMkD0OABEQRmcmVChIqN3/WBJHoLVYxK7GK4TvZwIMIcANrC0xxpJSOkzOOXjvASvUBOdcOxzBoXeDRhO11p+QlBKEEKtNc2OMAcbYKxL1aTsrWE201u4lPB4zUUphzrn8r9HA2+95BBgA3YASwqCieowAAAAASUVORK5CYII=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/sort_down.png,importbuddy/assets/dist/images/sort_down.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/white-grad.png,importbuddy/assets/dist/images/white-grad.png
iVBORw0KGgoAAAANSUhEUgAAAAUAAAAeCAYAAADkftS9AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAALEgAACxIB0t1+/AAAACF0RVh0U29mdHdhcmUATWFjcm9tZWRpYSBGaXJld29ya3MgNC4w6iYndQAAABZ0RVh0Q3JlYXRpb24gVGltZQAxMS8xNy8wONpsdXEAAAAlSURBVHicY/z///9/BjTAhC7AwMDAwIJFIXbBoaJ9qLhz+IUSAIMMOibeSzRBAAAAAElFTkSuQmCC
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/white-grad.png,importbuddy/assets/dist/images/white-grad.png
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/images/working.gif,importbuddy/assets/dist/images/working.gif
R0lGODlhKwALAPEAAPn5+SiKt5LC2CiKtyH/C05FVFNDQVBFMi4wAwEAAAAh/hpDcmVhdGVkIHdpdGggYWpheGxvYWQuaW5mbwAh+QQJCgAAACwAAAAAKwALAAACMoSOCMuW2diD88UKG95W88uF4DaGWFmhZid93pq+pwxnLUnXh8ou+sSz+T64oCAyTBUAACH5BAkKAAAALAAAAAArAAsAAAI9xI4IyyAPYWOxmoTHrHzzmGHe94xkmJifyqFKQ0pwLLgHa82xrekkDrIBZRQab1jyfY7KTtPimixiUsevAAAh+QQJCgAAACwAAAAAKwALAAACPYSOCMswD2FjqZpqW9xv4g8KE7d54XmMpNSgqLoOpgvC60xjNonnyc7p+VKamKw1zDCMR8rp8pksYlKorgAAIfkECQoAAAAsAAAAACsACwAAAkCEjgjLltnYmJS6Bxt+sfq5ZUyoNJ9HHlEqdCfFrqn7DrE2m7Wdj/2y45FkQ13t5itKdshFExC8YCLOEBX6AhQAADs=
###PACKDATA,FILE_END,/_importbuddy/importbuddy/assets/dist/images/working.gif,importbuddy/assets/dist/images/working.gif
###PACKDATA,FILE_START,/_importbuddy/importbuddy/assets/dist/js/importbuddy.js,importbuddy/assets/dist/js/importbuddy.js
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